/**  Affiche tactile interactive - 
 *  Quand on appuie sur une touche, cela lance une image, une vidéo, une annim, un son, etc...
 */
/// librairies
import processing.sound.*;
import processing.video.*; 


// variables globales
PImage im; // une image
SoundFile son; // un son
Movie vid, vid1,vid2, vid3, vid4; // une vidéo

float tailleCoeff=2;

// bouton son image active ?
boolean image_active = false;

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

void setup() {
  //size(500, 500); //taille de la fenetre d'affichage
  fullScreen();
  noStroke();
  background(0);
  noCursor();

  // initialisation des variables globales
  im = loadImage("images/chien.jpg");

  // chargement du son
  son = new SoundFile(this, "sons/Ernesto scène audio.mp3");
  //println(son.duration());

  // chargement de la video
  //vid = new Movie(this, "videos/anim balance.mp4");
  vid1 = new Movie(this, "videos/Petit François.3gp");
  vid2 = new Movie(this, "videos/the wall.mp4");
  vid3 = new Movie(this, "videos/anim balance.mp4");
  vid4= new Movie(this, "videos/Ernesto animation.mp4");
  vid = vid1;
}

void draw() { 

  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug

  if (son_actif) {
    background(0);
    float tempsEcoute = millis() - tempsDebutSon ;

    // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug

    if ( tempsEcoute >= son.duration()*1000) { // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }

  // gestion de la vidéo ////////////////////////////////////////
  if (video_active) {
    //image(vid, 0, 0, width, height);
    if (vid.width<width && vid.height <height) {
      image(vid, width/2-(vid.width * tailleCoeff)/2, height/2-(vid.height * tailleCoeff)/2, vid.width * tailleCoeff, vid.height * tailleCoeff);
    }
    else{
      image(vid, 0, 0, width, height);
    }
  } else {
    background(0); // fond noir
  }

  // gestion de l'image
  if (image_active) {
    float x = 30 + random(-20, 20); // random sur la position
    float y = 30 + random(-20, 20);
    image(im, x, y, 200, 200);
  }
}

void keyReleased() {
  if (key == CODED) {
    if (keyCode == UP) { // video 1
      // arrêter l'autre son qui tourne éventuellement
      son.stop();
      if (video_active == false) { // la vidéo 1 ne tourne pas
        // chargement de la video 1
        vid = vid1;
        vid.play();
        video_active = true;
      } else {
        vid.stop();
        clear();
        video_active = false;
      }
    } 

    if (keyCode == DOWN) { // video 2
      if (video_active == false) { // la vidéo 2 ne tourne pas
        // arrêter l'autre son qui tourne éventuellement
        son.stop();
        // chargement de la video 2
        //vid = new Movie(this, "videos/transit.mov");
        vid = vid2;
        vid.play();
        video_active = true;
      } else {
        vid.stop();
        clear();
        video_active = false;
      }
    }
    if (keyCode == LEFT) { // video 3
      if (video_active == false) { // la vidéo 2 ne tourne pas
        // arrêter l'autre son qui tourne éventuellement
        son.stop();
        // chargement de la video 2
        //vid = new Movie(this, "videos/transit.mov");
        vid =vid3;
        vid.play();
        video_active = true;
      } else {
        vid.stop();
        clear();
        video_active = false;
      }
    }

    if (keyCode == RIGHT) { // video 4
      if (video_active == false) { // la vidéo 2 ne tourne pas
        // arrêter l'autre son qui tourne éventuellement
        son.stop();
        // chargement de la video 2
        //vid = new Movie(this, "videos/transit.mov");
        vid = vid4;
        vid.play();
        video_active = true;
      } else {
        vid.stop();
        clear();
        video_active = false;
      }
    }
  }
  if (key == ' ') { // son
    if (son_actif==false) { // le son ne joue pas
      // arrêter l'autre son qui tourne éventuellement
      son.stop();
      // arrêter la video
      vid.stop();
      video_active = false;
      background(0);                                 
      // chargement du son 1
      son = new SoundFile(this, "sons/Ernesto scène audio.mp3");
      son.play();
      tempsDebutSon = millis();
      son_actif = true; // bouton son_actif on
    } else { // le son joue
      son.stop();
      son_actif = false;
    }
  }
}

void movieEvent(Movie movie) {
  vid.read();
}
