/*
Branchement sur ARduino NANO BLE
sur bread board - Branchement USB en bas
+ : 2 à droite
GND (-) : 14 à droite
ENtrée Bouton : 11 à gauche

*/

// constants won't change. They're used here to set pin numbers:
const int buttonPin = 2;     // the number of the pushbutton pin
const int ledPin =  13;      // the number of the LED pin

// variables will change:
int buttonState = 0;         // variable for reading the pushbutton status
int inByte = 0;         // incoming serial byte

void setup() {
  // initialize the LED pin as an output:
  pinMode(ledPin, OUTPUT);
  // initialize the pushbutton pin as an input:
  pinMode(buttonPin, INPUT);
  // port Série
  // start serial port at 9600 bps:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  // établir le contact avec Processing
  establishContact();  // send a byte to establish contact until receiver responds
}

void loop() {
  if (Serial.available() > 0) { // si un octet arrive sur le port série 
    //de la carte venant de Processing
    // get incoming byte:
    inByte = Serial.read();
    
    // read the state of the pushbutton value:
    buttonState = digitalRead(buttonPin);

    // check if the pushbutton is pressed. If it is, the buttonState is HIGH.
    // //et envoi de la valeur
    if (buttonState == HIGH) { // bouton appuyé => 5V en D2 => envoi de 255 et allumer LED 13
      //Serial.println(255);
      Serial.write(255);
      // turn LED on:
      digitalWrite(ledPin, HIGH);
    } else { // bouton relâché => 0V en D2 => envoi de 0 et éteindre LED 13
      //Serial.println(0);
      byte zero = 0;
      Serial.write(zero);
      // turn LED off:
      digitalWrite(ledPin, LOW);
    }
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}
