/* Meet
  Nouvelle réunion
  Rejoindre une réunion
  Hangouts
  2 sur 8 224
  RFID
  Boîte de réception
  Théo Radakovitch <theo@lafabulerie.com>

  14:43 (il y a 2 minutes)

  À moi, Célia

  Traduire le message
  Désactiver pour : anglais
  /* Typical pin layout used:
   -----------------------------------------------------------------------------------------
               MFRC522      Arduino       Arduino   Arduino    Arduino          Arduino
               Reader/PCD   Uno/101       Mega      Nano v3    Leonardo/Micro   Pro Micro
   Signal      Pin          Pin           Pin       Pin        Pin              Pin
   -----------------------------------------------------------------------------------------
   RST/Reset   RST          9             5         D9         RESET/ICSP-5     RST
   SPI SS      SDA(SS)      10            53        D10        10               10
   SPI MOSI    MOSI         11 / ICSP-4   51        D11        ICSP-4           16
   SPI MISO    MISO         12 / ICSP-1   50        D12        ICSP-1           14
   SPI SCK     SCK          13 / ICSP-3   52        D13        ICSP-3           15
*/
//////////////////////////SON///////////////////
#include "WT2003S_Player.h"


#ifdef __AVR__
#include <SoftwareSerial.h>
SoftwareSerial SSerial(2, 3); // RX, TX
#define COMSerial SSerial
#define ShowSerial Serial

WT2003S<SoftwareSerial> Mp3Player;
#endif

#ifdef ARDUINO_SAMD_VARIANT_COMPLIANCE
#define COMSerial Serial1
#define ShowSerial SerialUSB

WT2003S<Uart> Mp3Player;
#endif

#ifdef ARDUINO_ARCH_STM32F4
#define COMSerial Serial
#define ShowSerial SerialUSB

WT2003S<HardwareSerial> Mp3Player;
#endif


uint8_t vol = 31;
uint32_t spi_flash_songs = 0;
uint32_t sd_songs = 0;
STROAGE workdisk = SD;
struct Play_history {
  uint8_t disk;
  uint16_t index;
  char name[8];
}* SPISong, *SDSong;

void readSongName(struct Play_history* ph, uint32_t num, STROAGE disk) {
  Mp3Player.volume(0);
  delay(100);
  switch (disk) {
    case SPIFLASH:
      Mp3Player.playSPIFlashSong(0x0001);
      break;
    case SD:
      Mp3Player.playSDRootSong(0x0001);
      break;
    case UDISK:
      Mp3Player.playUDiskRootSong(0x0001);
      break;
  }
  ShowSerial.println("2...");
  for (int i = 0; i < num ; i++) {
    delay(300);
    ph[i].disk = disk;
    ph[i].index = Mp3Player.getTracks();
    Mp3Player.getSongName(ph[i].name);
    Mp3Player.next();
  }
  ShowSerial.println("4...");
  Mp3Player.pause_or_play();
  Mp3Player.volume(14);
  delay(100);
}

void getAllSong() {
  uint8_t diskstatus = Mp3Player.getDiskStatus();
  ShowSerial.println(diskstatus);
  spi_flash_songs = Mp3Player.getSPIFlashMp3FileNumber();
  ShowSerial.print("SPIFlash:");
  ShowSerial.println(spi_flash_songs);
  if (spi_flash_songs > 0) {
    SPISong = (struct Play_history*)malloc((spi_flash_songs + 1) * sizeof(struct Play_history));
    readSongName(SPISong, spi_flash_songs, SPIFLASH);
  }
  if (diskstatus && 0x02) { // have SD
    sd_songs = Mp3Player.getSDMp3FileNumber();
    ShowSerial.print("SD:");
    ShowSerial.println(sd_songs);
    if (sd_songs > 0) {
      SDSong = (struct Play_history*)malloc((sd_songs + 1) * sizeof(struct Play_history));
      ShowSerial.println("1...");
      readSongName(SDSong, sd_songs, SD);
    }
  }
}
void printSongs() {
  ShowSerial.print("-------------------");
  ShowSerial.print("index");
  ShowSerial.print("<-------->");
  ShowSerial.print("name");
  ShowSerial.print("-------------------");
  ShowSerial.println();
  ShowSerial.println("-------------------spi flash-------------------------------");
  for (int i = 0 ; i < spi_flash_songs; i++) {
    ShowSerial.print("-------------------");
    ShowSerial.print(SPISong[i].index);
    ShowSerial.print("<-------->");
    ShowSerial.print(SPISong[i].name);
    ShowSerial.print("-------------------");
    ShowSerial.println();
  }
  ShowSerial.println("-------------------sd card-------------------------------");
  for (int i = 0 ; i < sd_songs; i++) {
    ShowSerial.print("-------------------");
    ShowSerial.print(SDSong[i].index);
    ShowSerial.print("<-------->");
    ShowSerial.print(SDSong[i].name);
    ShowSerial.print("-------------------");
    ShowSerial.println();
  }
}
//////////////////////////////// RFID ////////////
#include <SPI.h>
#include <MFRC522.h>

#define SS_PIN 10
#define RST_PIN 9

MFRC522 rfid(SS_PIN, RST_PIN); // Instance of the class

MFRC522::MIFARE_Key key;

// Init array that will store new NUID
byte nuidPICC[4];

int valRFID = 0; // numéro de tag RFID

//DFPLAYER

#include <SoftwareSerial.h>



int ledPin = 6;



void setup()
{
  //Serial.begin(115200);

  SPI.begin(); // Init SPI bus
  rfid.PCD_Init(); // Init MFRC522

  for (byte i = 0; i < 6; i++) {
    key.keyByte[i] = 0xFF;
  }

  Serial.println(F("This code scan the MIFARE Classsic NUID."));
  Serial.print(F("Using the following key:"));
  printHex(key.keyByte, MFRC522::MF_KEY_SIZE);



  Serial.println("initializing RFID...");

  /////////////////SON //////////////////

  while (!ShowSerial);
  ShowSerial.begin(9600);
  COMSerial.begin(9600);
  ShowSerial.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++");
  Mp3Player.init(COMSerial);

  ShowSerial.println("0...");
  getAllSong();
  printSongs();
  Mp3Player.volume(vol);



}

void light() { // éclaire la led 3secondes après déclenchement son
  digitalWrite(ledPin, HIGH);
  digitalWrite(ledPin, LOW);
}


void printHex(byte *buffer, byte bufferSize) {
  for (byte i = 0; i < bufferSize; i++) {
    Serial.print(buffer[i] < 0x10 ? " 0" : " ");
    Serial.print(buffer[i], HEX);
  }
}

/**
   Helper routine to dump a byte array as dec values to Serial.
*/
void printDec(byte *buffer, byte bufferSize) {
  for (byte i = 0; i < bufferSize ; i++) {
    Serial.print(buffer[i] < 0x10 ? " 0" : " ");
    Serial.print(buffer[i], DEC);
    Serial.println("");
    //valRFID = buffer[i];
  }
}

int convertNumRFID(byte *buffer, byte bufferSize) {
  int valRFID = 0;
  for (byte i = 0; i < bufferSize ; i++) {
    valRFID += buffer[i];
  }
  Serial.print("Numero Tag RFID = ");
  Serial.println(valRFID);
  return valRFID;
}

void audio(int cmd) {
  ShowSerial.print("play:");
  if (workdisk == SD) {
    Mp3Player.playSDRootSong(cmd);
    ShowSerial.print(cmd + ": ");
    ShowSerial.print(SDSong[cmd - '0'].name);
  }
  if (workdisk == SPIFLASH) {
    Mp3Player.playSPIFlashSong(cmd - '0' - 1);
    ShowSerial.print(cmd + ": ");
    ShowSerial.print(SPISong[cmd - '0'].name);
  }
  ShowSerial.println();
}

void loop() {

  // Reset the loop if no new card present on the sensor/reader. This saves the entire process when idle.
  if ( ! rfid.PICC_IsNewCardPresent())
    return;

  // Verify if the NUID has been readed
  if ( ! rfid.PICC_ReadCardSerial())
    return;

  printDec(rfid.uid.uidByte, rfid.uid.size);
  valRFID = convertNumRFID(rfid.uid.uidByte, rfid.uid.size);
  //debug
  Serial.print("valRFID = ");
  Serial.println(valRFID);


  Serial.println();

  // Halt PICC
  rfid.PICC_HaltA();

  // Stop encryption on PCD
  rfid.PCD_StopCrypto1();


  //Serial.println(valRFID);
  //delay(50);

  if (valRFID == 387) { // Sapin
    audio(1);
    Serial.println("Sapin");
    light();
  }

  if (valRFID == 403) { //Ours
    audio(7);
    Serial.println("Ours");
    light();
  }

  if (valRFID == 280) { // Chien
    audio(3);
    Serial.println("Chien");
    light();
  }

  if (valRFID == 499) {  // Chaise
    audio(4);
    Serial.println("Chaise");
    light();
  }

  if (valRFID == 607) {  // Bateau
    audio(5);
    Serial.println("Bateau");
    light();
  }
  if (valRFID == 673) {  // Perroquet
    audio(6);
    Serial.println("Perroquet");
    light();
  }
  if (valRFID == 581) {  // Vache
    audio(2);
    Serial.println("Vache");
    light();
  }
}
