int Sensor [ ] = {0, 0, 0, 0, 0};
byte N = 5;
int inByte = 0;         // incoming serial byte

boolean debug = false;



void setup() {
  // création du tableau Sensor
  //  Sensor = malloc(N*sizeof(int));

  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  establishContact();  // send a byte to establish contact until receiver responds
}


void loop() {
  for (int i = 0; i < N; i++) {
    //lire la valeur du capteur
    Sensor [i] = map(analogRead(i), 0, 1023, 0, 255);
    //envoyer la valeur
    if (debug) {
      Serial.print("Sensor[");
      Serial.print(i);
      Serial.print("]=");
      Serial.print(Sensor[i]);
      Serial.print("    ");
    }
    else {
      Serial.write(Sensor[i]);
    }
  }
  if (debug) {
    Serial.println("");
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}
