k
///librairies
import processing.opengl.*; // librairie qui initialise la 3D
import SimpleOpenNI.*; // librairie de la kinect 
import ddf.minim.*; // librairie de son 

// variable globale
SimpleOpenNI kinect;
float rotation = 0;

// three AudioPlayer objects this time // 3 son iclu dans le sketch
Minim minim;
AudioPlayer kick;
AudioPlayer snare;
AudioPlayer sound3;

// declare our three hotpoint objects // déclare les 3 objets préciser par la class hotpoint
Hotpoint snareTrigger;
Hotpoint kickTrigger;
Hotpoint sound3Trigger;

float s = 1;

void setup() {
  size(1024, 768, OPENGL);
  kinect = new SimpleOpenNI(this); // instancie la librairie SimpleOpenNi
  kinect.enableDepth(); // permet la profondeur 

  minim = new Minim(this);
  // load both audio files // importation des sons 
  snare = minim.loadFile("Jackin_Bass01(125BPM).wav");
  kick = minim.loadFile("Jackin_Beat01a(125BPM).wav");
  sound3 = minim.loadFile("Jackin_Beat10a(125BPM).wav");
  
  // initialize hotpoints with their origins (x,y,z) and their size // initialise les objets avec leurs origines (x,y,z) et leur taille
  snareTrigger = new Hotpoint(400, 0, 600, 300);
  kickTrigger = new Hotpoint(-400, 0, 600, 150);
  sound3Trigger = new Hotpoint(0, 0, 600, 150);
  
}

void draw() {
  background(0); // fond de la fenêtre
  kinect.update(); // mise à jour de la kinect

  translate(width/2, height/2, -1000); // permet de réduire par 2 la représentation de l'espace de la kinect et de placer l'affichage dans la profondeur
  rotateX(radians(180));// determine le placement la représentation et permet une rotation

  translate(0, 0, 1400); // detemine le placement de la représentation sur l'axe des y 
  rotateY(radians(map(mouseX, 0, width, -180, 180))); // determine les valeur du mouvement de la rotation exercer avec la souris 

  translate(0, 0, s*-1000); // determine l'échelle de la représentation dans l'axe des z (profondeur)
  scale(s); // renomme le traitement de l'échelle sous l'appelation "s" qui sera réutiliser dans la ligne précédente ce qui permet de changer l'échelle sur un seul axe

  stroke(255); // couleur des lignes de l'espace environnant ( les gens qui se mettent en face de la kinect, le mur au fond ...)

  PVector[] depthPoints = kinect.depthMapRealWorld(); // création du tableau de vecteur depthPoints : ce sont les points de l'environement, ils sont donnés par la kinect avec la méthode propre à elle qui s'appelle depthMapRealWorld

  for (int i = 0; i < depthPoints.length; i+=10) { // boucle permettant de créer tout de 10 en 10 les points detecté par la kinect par depthPoints
    PVector currentPoint = depthPoints[i]; // créer les vecteurs du tableau des points(en cours d'analyse) depthPoint qui s'appelera currentPoint 

    // have each hotpoint check to see 
    // if it includes the currentPoint
    // pour chaque objets est vérifier que la personne/la main touche ou ne touche pas l'objet
    snareTrigger.check(currentPoint); // check , méthode développé dans la class Hotpoint (résumé dans le commentaire de la ligne précédente) our l'objet snareTrigger
    kickTrigger.check(currentPoint); // "" kickTrigger
    sound3Trigger.check(currentPoint); // "" sound3Trigger

    point(currentPoint.x, currentPoint.y, currentPoint.z); //points qui determinent/visualisent l'environnement (le/les corps, les objets, les murs ...) 
  }

  println(snareTrigger.pointsIncluded); //le programme écrit la valeur/position des points de l'environnement qui sont inclu dans l'objet snareTrigger


// A VERIFIER 
  if(snareTrigger.isHit()) { // si l'objet snareTrigger est touché, alors la musique snare se joue
    snare.play();
  }  
  
  if(!snare.isPlaying()) {  //quand snare (la musique liée à l'objet snareTrigger) ne joue plus, elle se rembobine et s'arrête
    snare.rewind();
    snare.pause();
  }

  if (kickTrigger.isHit()) { // si l'objet kickTrigger est touché, alors la musique snare se joue
    kick.play();
  }  
  
  if(!kick.isPlaying()) {//quand kick (la musique liée à l'objet kickTrigger) ne joue plus, elle se rembobine et s'arrête
    kick.rewind();
    kick.pause();
  } 
  
  if (sound3Trigger.isHit()) {// si l'objet sound3Trigger est touché, alors la musique snare se joue
    sound3.play();
  }  
  
  if(!sound3.isPlaying()) {//quand sound3 (la musique liée à l'objet sound3Trigger) ne joue plus, elle se rembobine et s'arrête
    sound3.rewind();
    sound3.pause();
  } 
  
  // display each hotpoint
  // and clear its points
  snareTrigger.draw();//execution de méthode draw issue de la class hotpoint (création des hotpoints)
  snareTrigger.clear();//après introducion de la main dans l'objet cube, le cube est réinitialisé permettant de redémarrer le sketch
  
  kickTrigger.draw();
  kickTrigger.clear();
  
  sound3Trigger.draw();
  sound3Trigger.clear();
}

void stop() // Méthode personelle
{
  // make sure to close
  // both AudioPlayer objects
  //méthode pour être certain que tout les sons à la fin du sketch s'arrête
  kick.close();
  snare.close();
  sound3.close();

  minim.stop();
  super.stop();
}

void keyPressed() {
  if (keyCode == 38) {// lorqu'on appui sur la flèche directionelle du haut on zoom (l'échelle des éléments augmente) 
    s = s + 0.01; // rappel : "s", c'est la scale , l'échelle des éléments 
  }
  if (keyCode == 40) {// lorqu'on appui sur la flèche directionelle du bas on dézoom (l'échelle des éléments diminue) 
    s = s - 0.01;
  }
}

