//traquer couleur

// Import de la librairie vidéo de Processing
import processing.video.*;

// On déclare une objet de capture
Capture video; // Capture est une classe de la librairie video

// Déclaration d'une variable de couleur que l'on va traquer :
color trackColor; 



// déclaration de la variable permettrant d'enregistrer l'ensemble des points détectés
Snake snake;

// Nombre de points détectés -1 (car on commence à 0)
int nbPtsDetectes=0;

void setup() {
  //background(255);
  size(320,240); // J'utilise un format vidéo pour ne pas déformer l'image.
  video = new Capture(this,width,height,15); // Par défaut, on spécifie this comme source.
 video.start();
 // précision de la couleur 
  trackColor = color(#36F01B);
  // Instanciation de la la variable snake avec 20 points au maximum
  snake = new Snake(20);
  
}

void draw() {
 // Dans draw, 1ÈRE ÉTAPE :
 //si une image est prête, on la lit :
  if (video.available()) {
    video.read();
  }
  
  video.loadPixels();
  // Puis on l'affiche :
  image(video,0,0);
 
 // Déclaration d'une variable pour le seuil de comparaison :
  float seuil = 100; 

  // ? XY coordinate of closest color
   int closestX = 0;
   int closestY = 0;

  // 2ÈME ÉTAPE :
 
// Boucle scanner des pixels de l'image :
// Pour chaque valeur de pixel en largeur (ligne après ligne) :
  for (int x = 0; x < video.width; x ++ ) {
    // Je fouille tous les pixels dans la hauteur (j'explore la colonne) :
    for (int y = 0; y < video.height; y ++ ) {
      int loc = x + y*video.width;
      
      // Puis j'étudie la couleur locale :
      color CouleurLocale = video.pixels[loc];
      // Je récupère les valeurs rouge, verte, et bleue dans des variables séparées :
      float r1 = red(CouleurLocale);
      float g1 = green(CouleurLocale);
      float b1 = blue(CouleurLocale);
      // Puis je remplis des variables pour contenir les valeurs rouge, verte, et bleue que je recherche :
      float r2 = red(trackColor);
      float g2 = green(trackColor);
      float b2 = blue(trackColor);

      // Puis comparaison entre la couleur locale du pixel local et la couleur traquée :
      float diffcouleur = dist(r1,g1,b1,r2,g2,b2); 
      
     // Si la couleur locale est sous le seuil, je dessine une ellipse sur ce point :
      if (diffcouleur < seuil) {
        seuil = diffcouleur;
        closestX = x;
        closestY = y;
      }
    }
  }

  // We only consider the color found if its color distance is less than 10. 
  // This threshold of 10 is arbitrary and you can adjust this number depending on how accurate you require the tracking to be.
  if (seuil < 90) { 
    // Incrémentation du nombre de points détectés
    nbPtsDetectes++;
    
    // Rajout du dernier point détecté au snake
    snake.update(closestX,closestY);
   }
   //  Dessin du snake 
     //snake.display(nbPtsDetectes);
     snake.display();
  
}
    


  void mousePressed() {  
  // enregistre la couleur qui va etre traquée 
   int loc = mouseX + mouseY*video.width;
    trackColor = video.pixels[loc];
}