/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.utils.Tools;
import processing.core.PApplet;
import processing.core.PImage;

public class Convolution {
    public static double kernelSum(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                d += dArray[i][j];
            }
        }
        return d;
    }

    public static PImage apply(PImage pImage, double[][] dArray) {
        PImage pImage2 = Tools.createImage(pImage.width, pImage.height, 1, pImage);
        double d = Convolution.kernelSum(dArray);
        int n = dArray.length;
        int n2 = n / 2;
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (n3 = -n2; n3 <= n2; ++n3) {
                    for (int k = -n2; k <= n2; ++k) {
                        if (n3 * n3 + k * k >= dArray.length * dArray.length) continue;
                        int n7 = pImage.get(i + n3, j + k);
                        n4 = (int)((double)n4 + (double)(n7 >> 16 & 0xFF) * dArray[n3 + n2][k + n2]);
                        n5 = (int)((double)n5 + (double)(n7 >> 8 & 0xFF) * dArray[n3 + n2][k + n2]);
                        n6 = (int)((double)n6 + (double)(n7 & 0xFF) * dArray[n3 + n2][k + n2]);
                    }
                }
                n4 = PApplet.constrain((int)n4, (int)0, (int)255);
                n5 = PApplet.constrain((int)n5, (int)0, (int)255);
                n6 = PApplet.constrain((int)n6, (int)0, (int)255);
                n3 = (int)((double)n4 / d) << 16 | (int)((double)n5 / d) << 8 | (int)((double)n6 / d);
                pImage2.set(i, j, n3);
            }
        }
        return pImage2;
    }
}

