/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import processing.core.PGraphics;
import processing.core.PImage;

public class Halftone {
    private static final double SQUARE_ROOT_2 = Math.sqrt(2.0);

    public static PImage apply(PImage pImage) {
        return Halftone.apply(pImage, 100);
    }

    public static PImage apply(PImage pImage, int n) {
        return Halftone.apply(pImage, n, 0, 255, 1, false);
    }

    public static PImage apply(PImage pImage, int n, boolean bl) {
        return Halftone.apply(pImage, n, 0, 255, 1, bl);
    }

    public static PImage apply(PImage pImage, int n, int n2, int n3) {
        return Halftone.apply(pImage, n, n2, n3, 1, false);
    }

    public static PImage apply(PImage pImage, int n, int n2, int n3, boolean bl) {
        return Halftone.apply(pImage, n, n2, n3, 1, bl);
    }

    public static PImage apply(PImage pImage, int n, int n2, int n3, int n4, boolean bl) {
        if (pImage.width <= 0 || pImage.height <= 0 || n <= 0) {
            return pImage;
        }
        PGraphics pGraphics = pImage.parent.createGraphics(pImage.width, pImage.width);
        pGraphics.ellipseMode(3);
        pGraphics.beginDraw();
        pGraphics.noStroke();
        pGraphics.background(n3);
        pGraphics.fill(n2);
        int n5 = 0;
        for (int i = 0; i < pGraphics.width; i += n + n4) {
            for (int j = n5; j < pGraphics.height; j += n + n4) {
                int n6 = pImage.get(j + n / 2, i + n / 2);
                double d = (0.2125 * (double)(n6 >> 16 & 0xFF) + 0.7154 * (double)(n6 >> 8 & 0xFF) + 0.0721 * (double)(n6 >> 0 & 0xFF)) / 255.0;
                d = 1.0 - d;
                double d2 = d * SQUARE_ROOT_2;
                pGraphics.ellipse((float)j, (float)i, (float)(d2 * (double)n), (float)(d2 * (double)n));
            }
            if (bl) continue;
            n5 = n5 == 0 ? n / 2 : 0;
        }
        pGraphics.endDraw();
        return pGraphics.get();
    }
}

