/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class Lights {
    public static PImage apply(PImage pImage, float f) {
        if (f == 0.0f) {
            return pImage;
        }
        f = f > 1.0f ? 1.0f : f;
        f = f < -1.0f ? -1.0f : f;
        PImage pImage2 = Tools.createBlankImageLike(pImage);
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n = pImage.get(i, j);
                float[] fArray = Tools.rgbToHsb(n);
                fArray[2] = fArray[2] + fArray[2] * f;
                fArray[2] = fArray[2] > 1.0f ? 1.0f : fArray[2];
                fArray[2] = fArray[2] < 0.0f ? 0.0f : fArray[2];
                pImage2.set(i, j, Tools.hsbToRgb(fArray));
            }
        }
        return pImage2;
    }
}

