/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;
import processing.core.PImage;

public class Tools {
    public static void set(PImage pImage, int n, int n2, int n3) {
        pImage.pixels[n + pImage.width * n2] = n3;
    }

    public static void set(PImage pImage, int n, int n2, int[] nArray) {
        Tools.set(pImage, n, n2, nArray[0], nArray[1], nArray[2]);
    }

    public static void set(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        pImage.pixels[n + pImage.width * n2] = n3 << 16 | n4 << 8 | n5;
    }

    public static int get(PImage pImage, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= pImage.width || n2 >= pImage.height) {
            return 0;
        }
        return pImage.pixels[n + pImage.width * n2];
    }

    public static int[] getColors(PImage pImage, int n, int n2) {
        return Tools.getRGB(Tools.get(pImage, n, n2));
    }

    public static PImage createImage(int n, int n2, int n3) {
        PImage pImage = new PImage(n, n2, n3);
        return pImage;
    }

    public static List<Integer> getNeighbors(PImage pImage, int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                arrayList.add(pImage.get(n + i, n2 + j));
            }
        }
        return arrayList;
    }

    public static PImage createImage(int n, int n2, int n3, PImage pImage) {
        PImage pImage2 = Tools.createImage(n, n2, n3);
        pImage2.parent = pImage.parent;
        return pImage2;
    }

    public int[] getArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
        return nArray;
    }

    public static PImage createBlankImageLike(PImage pImage) {
        return Tools.createImage(pImage.width, pImage.height, pImage.format, pImage);
    }

    public static int[] getRGB(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return new int[]{n2, n3, n4};
    }

    public static int getRGB(int n, int n2, int n3) {
        return n << 16 | n2 << 8 | n3;
    }

    public static float[] rgbToHsb(int n) {
        int[] nArray = Tools.getRGB(n);
        return Tools.rgbToHsb(nArray[0], nArray[1], nArray[2]);
    }

    public static float[] rgbToHsb(int n, int n2, int n3) {
        float[] fArray = Color.RGBtoHSB(n, n2, n3, new float[3]);
        fArray[0] = PApplet.map((float)fArray[0], (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
        return fArray;
    }

    public static int hsbToRgb(float[] fArray) {
        return Tools.hsbToRgb(fArray[0], fArray[1], fArray[2]);
    }

    public static int hsbToRgb(float f, float f2, float f3) {
        f = PApplet.map((float)f, (float)0.0f, (float)360.0f, (float)0.0f, (float)1.0f);
        return Color.HSBtoRGB(f, f2, f3);
    }

    public static boolean in(int n, int n2, int n3) {
        return Tools.in((float)n, (float)n2, (float)n3);
    }

    public static boolean in(float f, float f2, float f3) {
        return f >= f2 && f <= f3;
    }

    public static void copyChannel(PImage pImage, PImage pImage2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int[] nArray = Tools.getColors(pImage, j, i);
                int n9 = 0;
                switch (n7) {
                    case 1: {
                        n9 = nArray[0];
                        break;
                    }
                    case 2: {
                        n9 = nArray[1];
                        break;
                    }
                    case 3: {
                        n9 = nArray[2];
                    }
                }
                int[] nArray2 = Tools.getColors(pImage2, j, i);
                switch (n8) {
                    case 1: {
                        nArray2[0] = n9;
                        break;
                    }
                    case 2: {
                        nArray2[1] = n9;
                        break;
                    }
                    case 3: {
                        nArray2[2] = n9;
                    }
                }
                pImage2.set(j, i, Tools.getRGB(nArray2[0], nArray2[1], nArray2[2]));
            }
        }
    }
}

