/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.utils.Tools;
import processing.core.PApplet;
import processing.core.PImage;

public class ColorShift {
    public static PImage apply(PImage pImage, int n) {
        PImage pImage2 = pImage.copy();
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n2 = pImage.get(i, j);
                float[] fArray = Tools.rgbToHsb(n2);
                fArray[0] = fArray[0] + (float)n;
                fArray[0] = PApplet.constrain((float)fArray[0], (float)0.0f, (float)360.0f);
                n2 = Tools.hsbToRgb(fArray[0], fArray[1], fArray[2]);
                pImage2.set(i, j, n2);
            }
        }
        return pImage2;
    }

    public static PImage apply(PImage pImage, int n, int n2, int n3) {
        return ColorShift.applyHue(pImage, n, n2, n3);
    }

    public static PImage applyHue(PImage pImage, int n, int n2, int n3) {
        PImage pImage2 = pImage.copy();
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n4 = pImage.get(i, j);
                float[] fArray = Tools.rgbToHsb(n4);
                if (Tools.in((float)n, fArray[0] - (float)n2, fArray[0] + (float)n2)) {
                    fArray[0] = fArray[0] + (float)n3;
                    fArray[0] = PApplet.constrain((float)fArray[0], (float)0.0f, (float)360.0f);
                }
                n4 = Tools.hsbToRgb(fArray[0], fArray[1], fArray[2]);
                pImage2.set(i, j, n4);
            }
        }
        return pImage2;
    }

    public static PImage applySaturation(PImage pImage, int n, int n2, float f) {
        PImage pImage2 = pImage.copy();
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n3 = pImage.get(i, j);
                float[] fArray = Tools.rgbToHsb(n3);
                if (Tools.in((float)n, fArray[0] - (float)n2, fArray[0] + (float)n2)) {
                    fArray[1] = fArray[1] + f;
                    fArray[1] = PApplet.constrain((float)fArray[1], (float)0.0f, (float)1.0f);
                }
                n3 = Tools.hsbToRgb(fArray[0], fArray[1], fArray[2]);
                pImage2.set(i, j, n3);
            }
        }
        return pImage2;
    }

    public static PImage applyBrightness(PImage pImage, int n, int n2, float f) {
        PImage pImage2 = pImage.copy();
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n3 = pImage.get(i, j);
                float[] fArray = Tools.rgbToHsb(n3);
                if (Tools.in((float)n, fArray[0] - (float)n2, fArray[0] + (float)n2)) {
                    fArray[2] = fArray[2] + f;
                    fArray[2] = PApplet.constrain((float)fArray[2], (float)0.0f, (float)1.0f);
                }
                n3 = Tools.hsbToRgb(fArray[0], fArray[1], fArray[2]);
                pImage2.set(i, j, n3);
            }
        }
        return pImage2;
    }
}

