/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class Dithering {
    public static final float[] BAYER_2x2 = new float[]{127.0f, 191.0f, 255.0f, 63.0f};
    public static final float[] BAYER_4x4 = new float[]{31.875f, 255.0f, 47.8125f, 207.1875f, 159.375f, 95.625f, 175.3125f, 111.5625f, 63.75f, 223.125f, 15.9375f, 239.0625f, 191.25f, 127.5f, 143.4375f, 79.6875f};
    public static final float[] BAYER_8x8 = new float[]{3.0f, 131.0f, 35.0f, 163.0f, 11.0f, 139.0f, 43.0f, 171.0f, 195.0f, 67.0f, 227.0f, 99.0f, 203.0f, 75.0f, 235.0f, 107.0f, 51.0f, 179.0f, 19.0f, 147.0f, 59.0f, 187.0f, 27.0f, 155.0f, 243.0f, 115.0f, 211.0f, 83.0f, 251.0f, 123.0f, 219.0f, 91.0f, 15.0f, 143.0f, 47.0f, 175.0f, 7.0f, 135.0f, 39.0f, 167.0f, 207.0f, 79.0f, 239.0f, 111.0f, 199.0f, 71.0f, 231.0f, 103.0f, 63.0f, 191.0f, 31.0f, 159.0f, 55.0f, 183.0f, 23.0f, 151.0f, 255.0f, 127.0f, 223.0f, 95.0f, 247.0f, 119.0f, 215.0f, 87.0f};

    public static PImage apply(PImage pImage) {
        return Dithering.apply(pImage, BAYER_4x4);
    }

    public static PImage apply(PImage pImage, Algorithm algorithm) {
        if (algorithm == Algorithm.BAYER_2x2) {
            return Dithering.apply(pImage, BAYER_2x2);
        }
        if (algorithm == Algorithm.BAYER_4x4) {
            return Dithering.apply(pImage, BAYER_4x4);
        }
        if (algorithm == Algorithm.BAYER_8x8) {
            return Dithering.apply(pImage, BAYER_8x8);
        }
        return Dithering.apply(pImage, BAYER_4x4);
    }

    public static PImage apply(PImage pImage, float[] fArray) {
        PImage pImage2 = Tools.createBlankImageLike(pImage);
        int n = (int)Math.sqrt(fArray.length);
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n2 = pImage.get(i, j);
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                if ((float)n3 >= fArray[j % n * n + i % n]) {
                    n6 = 255;
                }
                if ((float)n4 >= fArray[j % n * n + i % n]) {
                    n7 = 255;
                }
                if ((float)n5 >= fArray[j % n * n + i % n]) {
                    n8 = 255;
                }
                pImage2.set(i, j, n6 << 16 | n7 << 8 | n8);
            }
        }
        return pImage2;
    }

    public static enum Algorithm {
        BAYER_2x2,
        BAYER_4x4,
        BAYER_8x8;

    }
}

