/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import processing.core.PImage;

public class LUT {
    int[] lutR = new int[256];
    int[] lutG = new int[256];
    int[] lutB = new int[256];

    public LUT() {
        for (int i = 0; i < 256; ++i) {
            this.lutR[i] = i;
            this.lutG[i] = i;
            this.lutB[i] = i;
        }
    }

    public static LUT loadLut(String string) {
        return LUT.loadLut(new File(string));
    }

    public static LUT loadLut(STYLE sTYLE) {
        return LUT.loadLut(LUT.class.getResourceAsStream("/data/" + sTYLE.getFileName()));
    }

    public static LUT loadLut(File file) {
        try {
            return LUT.loadLut(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return new LUT();
        }
    }

    public static LUT loadLut(InputStream inputStream) {
        LUT lUT = new LUT();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            for (int i = 0; i < 256; ++i) {
                string = bufferedReader.readLine();
                String[] stringArray = string.split(" ");
                lUT.lutR[i] = Integer.parseInt(stringArray[0]);
                lUT.lutG[i] = Integer.parseInt(stringArray[1]);
                lUT.lutB[i] = Integer.parseInt(stringArray[2]);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return lUT;
    }

    public static void saveLut(String string, LUT lUT) {
        LUT.saveLut(new File(string), lUT);
    }

    public static void saveLut(File file, LUT lUT) {
        try {
            PrintWriter printWriter = new PrintWriter(file, "UTF-8");
            for (int i = 0; i < 256; ++i) {
                printWriter.println(lUT.lutR[i] + " " + lUT.lutG[i] + " " + lUT.lutB[i]);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static PImage apply(PImage pImage, LUT lUT) {
        PImage pImage2 = pImage.copy();
        pImage2.loadPixels();
        for (int i = 0; i < pImage2.pixels.length - 1; ++i) {
            int n;
            int n2 = pImage2.pixels[i];
            int n3 = n2 >> 24 & 0xFF;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            pImage2.pixels[i] = n = n3 << 24 | lUT.lutR[n4] << 16 | lUT.lutG[n5] << 8 | lUT.lutB[n6];
        }
        pImage2.updatePixels();
        return pImage2;
    }

    public static enum STYLE {
        RETRO,
        CONTRAST,
        CONTRAST_STRONG,
        ANALOG1,
        WINTER,
        SPRING,
        SUMMER,
        AUTUMN;


        public String getFileName() {
            return this.name().toLowerCase() + ".lut";
        }
    }
}

