/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import milchreis.imageprocessing.utils.Tools;
import processing.core.PApplet;
import processing.core.PImage;

public class SobelEdgeDetector {
    private static final double[][] SOBEL_X = new double[][]{{1.0, 0.0, -1.0}, {2.0, 0.0, -2.0}, {1.0, 0.0, -1.0}};
    private static final double[][] SOBEL_Y = new double[][]{{1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -2.0, -1.0}};

    public static PImage apply(PImage pImage) {
        return SobelEdgeDetector.apply(pImage, true);
    }

    public static PImage apply(PImage pImage, boolean bl) {
        PImage pImage2 = Tools.createBlankImageLike(pImage);
        int n = SOBEL_X.length;
        int n2 = n / 2;
        for (int i = 0; i < pImage.width; ++i) {
            for (int j = 0; j < pImage.height; ++j) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                for (n6 = -n2; n6 <= n2; ++n6) {
                    for (n5 = -n2; n5 <= n2; ++n5) {
                        if (n6 * n6 + n5 * n5 >= SOBEL_X.length * SOBEL_X.length) continue;
                        n4 = pImage.get(i + n6, j + n5);
                        n7 = (int)((double)n7 + (double)(n4 >> 16 & 0xFF) * SOBEL_X[n6 + n2][n5 + n2]);
                        n8 = (int)((double)n8 + (double)(n4 >> 8 & 0xFF) * SOBEL_X[n6 + n2][n5 + n2]);
                        n9 = (int)((double)n9 + (double)(n4 & 0xFF) * SOBEL_X[n6 + n2][n5 + n2]);
                        n10 = (int)((double)n10 + (double)(n4 >> 16 & 0xFF) * SOBEL_Y[n6 + n2][n5 + n2]);
                        n11 = (int)((double)n11 + (double)(n4 >> 8 & 0xFF) * SOBEL_Y[n6 + n2][n5 + n2]);
                        n12 = (int)((double)n12 + (double)(n4 & 0xFF) * SOBEL_Y[n6 + n2][n5 + n2]);
                    }
                }
                n6 = (int)Math.sqrt(n7 * n7 + n10 * n10);
                n5 = (int)Math.sqrt(n8 * n8 + n11 * n11);
                n4 = (int)Math.sqrt(n9 * n9 + n12 * n12);
                n6 = PApplet.constrain((int)n6, (int)0, (int)255);
                n5 = PApplet.constrain((int)n5, (int)0, (int)255);
                n4 = PApplet.constrain((int)n4, (int)0, (int)255);
                if (bl) {
                    n6 = n3 = (int)((double)n6 * 0.2125 + (double)n5 * 0.7154 + (double)n4 * 0.0721);
                    n5 = n3;
                    n4 = n3;
                }
                n3 = n6 << 16 | n5 << 8 | n4;
                pImage2.set(i, j, n3);
            }
        }
        return pImage2;
    }
}

