//   Projet: Interface synthetiseur MIDI PureData

//   Version 1.0

//   Contributeurs:

//     BUCHHEIT Olivier
//     CLAUDEL Sebastien
//     GERBER Thomas

//    micro-sillon.org

//    03-2017

//////////////////////////////////////////////////////////////////////////////////
// For Arduino Leonardo with arcode

//////////////////////////////////////////////////////////////////////////////////
// MIDI function

// First parameter is the event type (0x09 = note on, 0x08 = note off).
// Second parameter is note-on/note-off, combined with the channel.
// Channel can be anything between 0-15. Typically reported to the user as 1-16.
// Third parameter is the note number (48 = middle C).
// Fourth parameter is the velocity (64 = normal, 127 = fastest).

void noteOn(byte channel, byte pitch, byte velocity) {
  MIDIEvent noteOn = {0x09, 0x90 | channel, pitch, velocity};
  MIDIUSB.write(noteOn);
}

void noteOff(byte channel, byte pitch, byte velocity) {
  MIDIEvent noteOff = {0x08, 0x80 | channel, pitch, velocity};
  MIDIUSB.write(noteOff);
}

// First parameter is the event type (0x0B = control change).
// Second parameter is the event type, combined with the channel.
// Third parameter is the control number number (0-119).
// Fourth parameter is the control value (0-127).

void controlChange(byte channel, byte control, byte value) {
  MIDIEvent event = {0x0B, 0xB0 | channel, control, value};
  MIDIUSB.write(event);
}

//////////////////////////////////////////////////////////////////////////////////
// Library

#include <Bounce2.h>

//////////////////////////////////////////////////////////////////////////////////
// Debug

int DEBUG = 1;
//int DEBUG = 0;

//////////////////////////////////////////////////////////////////////////////////
// Definition of the IN/OUT PIN

#define SLIDE1    A0
#define SLIDE2    A1
#define POT1      A2
#define POT2      A3
#define POT3      A4
#define SWITCH    2
#define LED       3 // PWM
#define PUSH1     4
#define PUSH2     5
#define PUSH3     6
#define PUSH4     7
#define SLIDE_LED 9 // PWM

//////////////////////////////////////////////////////////////////////////////////
// Create instance Bounce object

Bounce DEBOUNCE_PUSH1 = Bounce();
Bounce DEBOUNCE_PUSH2 = Bounce();
Bounce DEBOUNCE_PUSH3 = Bounce();
Bounce DEBOUNCE_PUSH4 = Bounce();
Bounce DEBOUNCE_SWITCH = Bounce();

//////////////////////////////////////////////////////////////////////////////////
// Interval for debounce - depend of the quality of the switch

int DELAY = 5;

//////////////////////////////////////////////////////////////////////////////////
// variables

// Push button
int STATE_PUSH1 = 0;
int STATE_PUSH2 = 0;
int STATE_PUSH3 = 0;
int STATE_PUSH4 = 0;
int LAST_STATE_PUSH1 = 0;
int LAST_STATE_PUSH2 = 0;
int LAST_STATE_PUSH3 = 0;
int LAST_STATE_PUSH4 = 0;

// Switch
int STATE_SWITCH = 0;
int LAST_STATE_SWITCH = 0;

// LED
int RATE_LED = 0;
int RATE_SLIDE_LED = 0;

// Pot
int VALUE_POT1 = 0;
int VALUE_POT2 = 0;
int VALUE_POT3 = 0;
int LAST_VALUE_POT1 = 0;
int LAST_VALUE_POT2 = 0;
int LAST_VALUE_POT3 = 0;
int MIDI_VALUE_POT1 = 0;
int MIDI_VALUE_POT2 = 0;
int MIDI_VALUE_POT3 = 0;

// Silder
int VALUE_SLIDE1 = 0;
int VALUE_SLIDE2 = 0;
int LAST_VALUE_SLIDE1 = 0;
int LAST_VALUE_SLIDE2 = 0;
int MIDI_VALUE_SLIDE1 = 0;
int MIDI_VALUE_SLIDE2 = 0;


//////////////////////////////////////////////////////////////////////////////////
// Setup

void setup() {

  // For serial monitor
  Serial.begin(57600);
  delay(1000);
  
  // Push button
  pinMode(PUSH1, INPUT);
  DEBOUNCE_PUSH1.attach(PUSH1);
  DEBOUNCE_PUSH1.interval(DELAY);
  pinMode(PUSH2, INPUT);
  DEBOUNCE_PUSH2.attach(PUSH2);
  DEBOUNCE_PUSH2.interval(DELAY);
  pinMode(PUSH3, INPUT);
  DEBOUNCE_PUSH3.attach(PUSH3);
  DEBOUNCE_PUSH3.interval(DELAY);
  pinMode(PUSH4, INPUT);
  DEBOUNCE_PUSH4.attach(PUSH4);
  DEBOUNCE_PUSH4.interval(DELAY);
  
  // Switch
  pinMode(SWITCH, INPUT);
  DEBOUNCE_SWITCH.attach(SWITCH);
  DEBOUNCE_SWITCH.interval(DELAY);
  
  // LED
  pinMode(LED, OUTPUT);
  pinMode(SLIDE_LED, OUTPUT);
  
  // Slide
  pinMode(SLIDE1, INPUT);
  pinMode(SLIDE2, INPUT);
  
  // Pot
  pinMode(POT1, INPUT);
  pinMode(POT2, INPUT);
  pinMode(POT3, INPUT);

  Serial.println("Ready!");
}

//////////////////////////////////////////////////////////////////////////////////
// Loop

void loop() {

  // MIDI message received?
  while (MIDIUSB.available() > 0) {
    MIDIEvent e;
    e = MIDIUSB.read();
    MIDIUSB.flush();
    
    // If Channel 1, CC 7, get the value
    if (e.type ==  0x0B && e.m1 == 176 && e.m2 == 7) {
      if ( DEBUG == 1) {
        Serial.print("Rx Channel 1, CC7, value ");
        Serial.println(e.m3);
      }
      RATE_LED = e.m3;
      RATE_LED = map(RATE_LED, 0, 127, 0, 255);
      analogWrite(LED, RATE_LED);
    }
    // If Channel 1, CC 8, get the value
    if (e.type ==  0x0B && e.m1 == 176 && e.m2 == 8) {
      if ( DEBUG == 1) {
        Serial.print("Rx Channel 1, CC8, value ");
        Serial.println(e.m3);
      }
      RATE_SLIDE_LED = e.m3;
      RATE_SLIDE_LED = map(RATE_SLIDE_LED, 0, 127, 0, 255);
      analogWrite(SLIDE_LED, RATE_SLIDE_LED);
    }
  }

  // Update bounce instance and state of button
  DEBOUNCE_PUSH1.update();
  DEBOUNCE_PUSH2.update();
  DEBOUNCE_PUSH3.update();
  DEBOUNCE_PUSH4.update();
  DEBOUNCE_SWITCH.update();
  
  // Store state of button to variable
  int STATE_PUSH1 = DEBOUNCE_PUSH1.read();
  int STATE_PUSH2 = DEBOUNCE_PUSH2.read();
  int STATE_PUSH3 = DEBOUNCE_PUSH3.read();
  int STATE_PUSH4 = DEBOUNCE_PUSH4.read();
  int STATE_SWITCH = DEBOUNCE_SWITCH.read();

  // Update POT value
  VALUE_POT1 = analogRead(POT1);
  VALUE_POT2 = analogRead(POT2);
  VALUE_POT3 = analogRead(POT3);

  // Update SLIDE value
  VALUE_SLIDE1 = analogRead(SLIDE1);
  VALUE_SLIDE2 = analogRead(SLIDE2);

  // Update POT value
  VALUE_POT1 = analogRead(POT1);
  VALUE_POT2 = analogRead(POT2);
  VALUE_POT3 = analogRead(POT3);

  // Slide1 mouvement?
  if ( abs(LAST_VALUE_SLIDE1 - VALUE_SLIDE1) >=3 ) {
    LAST_VALUE_SLIDE1 = VALUE_SLIDE1;
    MIDI_VALUE_SLIDE1 = map(VALUE_SLIDE1, 0, 1023, 0, 127);
    if (LAST_STATE_SWITCH == 0) {
      controlChange(0, 0, MIDI_VALUE_SLIDE1);
      MIDIUSB.flush();
      if ( DEBUG == 1) {
        Serial.print("Tx Channel 1, CC0, value ");
        Serial.println(MIDI_VALUE_SLIDE1);
        
      }
    }
    if (LAST_STATE_SWITCH == 1) {
      controlChange(0, 1, MIDI_VALUE_SLIDE1);
      MIDIUSB.flush();
      if ( DEBUG == 1) {
        Serial.print("Tx Channel 1, CC1, value ");
        Serial.println(MIDI_VALUE_SLIDE1);
      }
    }
  }

  // Slide2 mouvement?
  if ( abs(LAST_VALUE_SLIDE2 - VALUE_SLIDE2) >=3 ) {
    LAST_VALUE_SLIDE2 = VALUE_SLIDE2;
    MIDI_VALUE_SLIDE2 = map(VALUE_SLIDE2, 0, 1023, 0, 127);
    if (LAST_STATE_SWITCH == 0) {
      controlChange(0, 2, MIDI_VALUE_SLIDE2);
      MIDIUSB.flush();
      if ( DEBUG == 1) {
        Serial.print("Tx Channel 1, CC2, value ");
        Serial.println(MIDI_VALUE_SLIDE2);
      }
    }
    if (LAST_STATE_SWITCH == 1) {
      controlChange(0, 3, MIDI_VALUE_SLIDE2);
      MIDIUSB.flush();
      if ( DEBUG == 1) {
        Serial.print("Tx Channel 1, CC3, value ");
        Serial.println(MIDI_VALUE_SLIDE2);
      }
    }
  }

  // Pot1 mouvement?
  if ( abs(LAST_VALUE_POT1 - VALUE_POT1) >= 3 ) {
    LAST_VALUE_POT1 = VALUE_POT1;
    MIDI_VALUE_POT1 = map(VALUE_POT1, 0, 1023, 127, 0);
    controlChange(0, 4, MIDI_VALUE_POT1);
    MIDIUSB.flush();
    if ( DEBUG == 1) {
      Serial.print("Tx Channel 1, CC4, value ");
      Serial.println(MIDI_VALUE_POT1);
    }
  }

  // Pot2 mouvement?
  if ( abs(LAST_VALUE_POT2 - VALUE_POT2) >= 3 ) {
    LAST_VALUE_POT2 = VALUE_POT2;
    MIDI_VALUE_POT2 = map(VALUE_POT2, 0, 1023, 127, 0);
    controlChange(0, 5, MIDI_VALUE_POT2);
    MIDIUSB.flush();
    if ( DEBUG == 1) {
      Serial.print("Tx Channel 1, CC5, value ");
      Serial.println(MIDI_VALUE_POT2);
    }
  }

  // Pot3 mouvement?
  if ( abs(LAST_VALUE_POT3 - VALUE_POT3) >= 3 ) {
    LAST_VALUE_POT3 = VALUE_POT3;
    MIDI_VALUE_POT3 = map(VALUE_POT3, 0, 1023, 127, 0);
    controlChange(0, 6, MIDI_VALUE_POT3);
    MIDIUSB.flush();
    if ( DEBUG == 1) {
      Serial.print("Tx Channel 1, CC6, value ");
      Serial.println(MIDI_VALUE_POT3);
    }
  }

  // SWITCH HIGH?
  if ( STATE_SWITCH == HIGH  && LAST_STATE_SWITCH == 0) {
        LAST_STATE_SWITCH = 1;
        controlChange(0, 10, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1) {
      Serial.println("SWITCH HIGH");
    }
  }
  
  // SWITCH LOW?
  if ( STATE_SWITCH == LOW  && LAST_STATE_SWITCH == 1) {
    LAST_STATE_SWITCH = 0;
    controlChange(0, 9, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1) {
      Serial.println("SWITCH LOW");
    }
  }

// PUSH 1?
 if (STATE_PUSH1 == HIGH &&  LAST_STATE_PUSH1 == 0) {
 LAST_STATE_PUSH1 = 1;
    noteOn(0, 1, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH1 pressed");
    Serial.println("Tx Channel 1, NoteON C# -2, value 127");
    }
  }
  if (STATE_PUSH1 == LOW && LAST_STATE_PUSH1 == 1) {
   LAST_STATE_PUSH1 = 2;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH1 released");
    }
  }
if (STATE_PUSH1 == HIGH && LAST_STATE_PUSH1 == 2) {
  LAST_STATE_PUSH1 = 3;
    noteOn(0, 1, 0);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH1 pressed");
    Serial.println("Tx Channel 1, NoteON C# -2, value 0");
    }
  }
  if (STATE_PUSH1 == LOW && LAST_STATE_PUSH1 == 3) {
   LAST_STATE_PUSH1 = 0;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH1 released");
    }
  }

// PUSH 2?
 if (STATE_PUSH2 == HIGH &&  LAST_STATE_PUSH2 == 0) {
 LAST_STATE_PUSH2 = 1;
    noteOn(0, 2, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH2 pressed");
    Serial.println("Tx Channel 1, NoteON D -2, value 127");
    }
  }
  if (STATE_PUSH2 == LOW && LAST_STATE_PUSH2 == 1) {
   LAST_STATE_PUSH2 = 2;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH2 released");
    }
  }
if (STATE_PUSH2 == HIGH && LAST_STATE_PUSH2 == 2) {
  LAST_STATE_PUSH2 = 3;
    noteOn(0, 2, 0);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH2 pressed");
    Serial.println("Tx Channel 1, NoteON D -2, value 0");
    }
  }
  if (STATE_PUSH2 == LOW && LAST_STATE_PUSH2 == 3) {
   LAST_STATE_PUSH2 = 0;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH2 released");
    }
  }

// PUSH 3?
 if (STATE_PUSH3 == HIGH &&  LAST_STATE_PUSH3 == 0) {
 LAST_STATE_PUSH3 = 1;
    noteOn(0, 3, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH3 pressed");
    Serial.println("Tx Channel 1, NoteON D# -2, value 127");
    }
  }
  if (STATE_PUSH3 == LOW && LAST_STATE_PUSH3 == 1) {
   LAST_STATE_PUSH3 = 2;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH3 released");
    }
  }
if (STATE_PUSH3 == HIGH && LAST_STATE_PUSH3 == 2) {
  LAST_STATE_PUSH3 = 3;
    noteOn(0, 3, 0);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH3 pressed");
    Serial.println("Tx Channel 1, NoteON D# -2, value 0");
    }
  }
  if (STATE_PUSH3 == LOW && LAST_STATE_PUSH3 == 3) {
   LAST_STATE_PUSH3 = 0;
   if ( DEBUG == 1 ) {
    Serial.println("Button PUSH3 released");
    }
  }

// PUSH 4 HIGH?
  if ( STATE_PUSH4== HIGH && LAST_STATE_PUSH4 == 0 ) {
    LAST_STATE_PUSH4 = 1;
    noteOn(0, 4, 127);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH4 pressed");
    Serial.println("Tx Channel 1, NoteON E -2, value 127");
    }
  }

  // PUSH 4 LOW?
  if ( STATE_PUSH4 == LOW && LAST_STATE_PUSH4 == 1 ) {
    LAST_STATE_PUSH4 = 0;
    noteOn(0, 4, 0);
    MIDIUSB.flush();
    if ( DEBUG == 1 ) {
    Serial.println("Button PUSH4 released");
    Serial.println("Tx Channel 1, NoteON E -2, value 0");
    }
  }
}
