
//Sévan PAPAZIAN
//DSAA1 MARSEILLE
//Projet d'oeuvre interractive "PATH"
//Tonerkebab.fr

//Basé sur le programme de: Daniel Shiffman:
// https://github.com/shiffman/OpenKinect-for-Processing
// http://shiffman.net/p5/kinect/


import org.openkinect.freenect.*;
import org.openkinect.processing.*;


PImage img;
float offset = 0;
float easing = 0.05;
int time;
// La programmation de la kinect en elle meme se passe dans les classes suivantes
KinectTracker tracker;
Kinect kinect;

// tableau dynamique pour la mémorisation de la position des points
ArrayList<PVector> dessin;



void setup() {
  size(1400, 700);
   img = loadImage("grille1.png");

  kinect = new Kinect(this);
  tracker = new KinectTracker();

  // initialisation de la liste vise
  dessin = new ArrayList<PVector>();
}

void draw() {
 fill(#FF2739);
  noStroke(); 
     rect(0, 650, 6400, 50);
     
  timer();
  // Demarre l'analyse du tracking
  tracker.track();
  // Montre l'image
  tracker.display();
  

  // Dessine un point la localisation brute de la zonne la plus proche du seuil de profondeur 
  PVector v1 = tracker.getPos();
  fill(50, 100, 250, 200);
  noStroke();
  ellipse(v1.x, v1.y, 20, 20);

  // Dessine un point pour la zone interpolée (le barycentre) de la zone la plus proche du seuil de profondeur   
  PVector v2 = tracker.getLerpedPos();
  
  // mémorisation de la position dans le ArrayList dessin
  dessin.add(v2);
  fill(100, 250, 50, 200);
  stroke(100);
  line(v2.x, v2.y, 20, 20);
 
  fill(3, 255, 118, 10);
  stroke(100);
  // petite fonctionalité suplémentaire permettant de tracer une ligne avec la souris
  if (mousePressed == true) {
    line(mouseX, mouseY, pmouseX, pmouseY);
  }

  
  //rect(640, 0, 520, 100);
  // permet d'affficher des info comme le seuil de profondeur 
  int t = tracker.getThreshold();
  fill(0);
  text("threshold: " + t + "    " +  "framerate: " + int(frameRate) + "    " + 
    "UP augmente le seuil , DOWN descend le seuil", 10, 680);

  // tracé du dessin
  //pushStyle();

  for (int i=0; i<dessin.size()-1; i++) { 
    fill(3, 255, 118, 10);
    stroke(10);
    line(dessin.get(i).x, dessin.get(i).y, dessin.get(i+1).x, dessin.get(i+1).y);
  }
  //popStyle();

  println(dessin.size());
 
 
}

 
 


// Permet d'ajuster le seuil de profondeur " treshold" avec les fleches 
void keyPressed() {
  int t = tracker.getThreshold();
  if (key == CODED) {
    if (keyCode == UP) {
      t+=5;
      tracker.setThreshold(t);
    } else if (keyCode == DOWN) {
      t-=5;
      tracker.setThreshold(t);
        
    }
  }
}
// timer qui permet de reset le background tout les 500 
void timer() {
  time++;
  if (time>500) {
    time = 0;
    // saveframe() permet de faire une capture d'écran et de l'enregister dans le dossier parent du programme 
    saveFrame();
    background(250);
    image(img,0,0,1280,650);
  }
}
