//Basé sur le thème de l’accident identitaire, le visuel proposé met en scène un 
//personnage en noir et blanc à la position pensive. Un rectangle bleu où sont 
//représentés les yeux d’une poupée renvoient au monde de l’enfance, un monde perdu 
//qui rende le personnage nostalgique. L’un des souvenirs les plus marquants de 
//l’enfance reste lors de la période de Noël, avec les fêtes et la neige. 
//C’est cette neige que j’ai voulu représenter en superposition à l’image 
//(utilisation de PImage) pour illustrer la nostalgie du personnage qui se remémore 
//son enfance en regardant la neige tomber.

//Incrustation du visuel

PImage visuel;

int howMany = 800;
float[] x = new float[howMany];
float[] y = new float[howMany];
float[] speed = new float[howMany];

void setup(){
  size(500,707);
  visuel =loadImage("Dolls_D.1.jpg");
  background(0);
  noStroke();
  smooth();

  int i = 0;
  while (i<howMany) {
    x[i] = random(0, width);
    y[i] =random(0, height);
    //rapidité du point (entre 1 et 5)
    speed[i] = random(1,5);
    //le point avance en ligne droite
    i +=1;
  }
}


void draw(){
  background(255);
  
  image(visuel, 0, 0);
  
  
  fill(0,10);
  rect(0,0,width, height);

  int i = 0;
  while (i < howMany) {
    //suivant si le point est plus ou moins clair, il avance plus ou moins vite. 
    //Cela donne de la profondeur.
    fill(50*speed[i]);
    //format du point
    ellipse(x[i], y[i],speed[i],speed[i]);
    y[i] += speed[i]/2;
    if (y[i] > height) {
      y[i] = 0;
    }
    i +=1;
  }
}