/*  
    Chloé Guironnet 
    Programme le serpent multicolore 
*/

// Importation des librairies
   import controlP5.*;
   ControlP5 cp5;

   int myColor = color(255); 

   int c1,c2;

   float n,n1;

// Déclaration des variables

   PVector[] points; // couleur en point 
   float ease = 0.5;
   boolean easing = true;
   int num=100, frames=165;

void setup() {
  size(600,600); // taille de la fenêtre 
  noStroke(); // pas de contour 
  cp5 = new ControlP5(this);
  
// créer un bouton avec le nom 'effet'
   cp5.addButton("effet") //nom du bouton 
   .setValue(0) // valeur de départ 
   .setPosition(10,10) // position du bouton dans la fenêtre
   .setSize(200,19) // taille du bouton 
     ;  
   
    
//information du serpent
   colorMode(HSB,360,100,100); // Mode de couleur HSB
   points = new PVector[num];
   for (int i=0; i<num; i++) { 
   points[i] = new PVector(width/2, height/2);
  }
}

void draw() {
  background(myColor); // appliquer l'effet mycolor pour le fond
  myColor = lerpColor(c1,c2,n); // paramètres de mycolor
  n += (1-n)* 0.1; 
  
// info serpent
  noStroke(); // pas de contour 
  PVector leader = new PVector(mouseX, mouseY); // interaction avec la souris 
  for (int i=0; i<num; i++) {
  fill(180.0/num*i,90,90); // remplissage des ronds 
  PVector point = points[i];
  PVector distance = PVector.sub(leader, point);
  PVector velocity = PVector.mult(distance, ease);
  point.add(velocity);
  ellipse(point.x, point.y, 70, 70); // création des ronds coloré 
  leader = point;
    }
}

// relatif au bouton 
  public void controlEvent(ControlEvent theEvent) {
  println(theEvent.getController().getName());
  n = 0;
}

// Effet de controle du bouton 
  public void effet(int theValue) {
  println("l'effet du bouton: "+theValue); // affichage dans la console 
  c1 = color(0,145,100); // couleur du fond
  c2 = color(0,14,100); // couleur du fond
}