/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.TickMark;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Slider
extends Controller<Slider> {
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected int _myHandleSize = 0;
    protected int _myDefaultHandleSize = 10;
    protected int triggerId = 1;
    protected ArrayList<TickMark> _myTickMarks = new ArrayList();
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected static int autoWidth = 99;
    protected static int autoHeight = 9;
    protected float scrollSensitivity = 0.1f;
    protected int _myColorTickMark = -1;
    private SliderView _myView;
    protected float _myMinReal = 0.0f;
    protected float _myMaxReal = 1.0f;
    protected float _myInternalValue = 0.0f;

    public Slider(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 100.0f, 0.0f, 0, 0, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    public Slider(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myMin = 0.0f;
        this._myMax = 1.0f;
        this._myMinReal = f;
        this._myMaxReal = f2;
        this._myValue = PApplet.map((float)f3, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this._myCaptionLabel = new Label(this.cp5, string).setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.cp5, "" + this.getValue()).setColor(this.color.getValueLabel());
        this.setSliderMode(1);
    }

    @Override
    @ControlP5.Invisible
    public void init() {
        this._myDefaultValue = this.getValue();
        this.cp5.getControlBroadcaster().plug((Object)this.cp5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.cp5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    public Slider setSliderMode(int n) {
        this._myView = this.getWidth() > this.getHeight() ? new SliderViewH() : new SliderViewV();
        this._myControllerView = this.getWidth() > this.getHeight() ? new SliderViewH() : new SliderViewV();
        this._mySliderMode = n;
        this._myHandleSize = this._mySliderMode == 0 ? (this._myDefaultHandleSize >= this.getHeight() / 2 ? this._myDefaultHandleSize / 2 : this._myDefaultHandleSize) : 0;
        this._myView.updateUnit();
        this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public int getSliderMode() {
        return this._mySliderMode;
    }

    public Slider setHandleSize(int n) {
        this._myDefaultHandleSize = n;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public int getHandleSize() {
        return this._myHandleSize;
    }

    @Override
    @ControlP5.Invisible
    public Slider updateInternalEvents(PApplet pApplet) {
        if (this.isVisible && this.isMousePressed && !this.cp5.isAltDown()) {
            this._myView.updateInternalEvents(pApplet);
        }
        return this;
    }

    public Slider setTriggerEvent(int n) {
        this.triggerId = n;
        return this;
    }

    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    protected void mouseReleased() {
        if (this.triggerId == 2) {
            this._myView.update();
            this.broadcast(2);
        }
    }

    protected Slider snapValue(float f) {
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
            this._myView.setSnapValue();
        }
        return this;
    }

    public float getValuePosition() {
        return this._myValuePosition;
    }

    @Override
    public Slider setValue(float f) {
        if (this.isMousePressed && f == this.getValue()) {
            return this;
        }
        this._myInternalValue = f;
        this._myValue = PApplet.map((float)f, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.snapValue(this._myValue);
        this._myValue = this._myValue <= this._myMin ? this._myMin : this._myValue;
        this._myValue = this._myValue >= this._myMax ? this._myMax : this._myValue;
        this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
        this._myValueLabel.set(this.adjustValue(this.getValue()));
        if (this.triggerId == 1) {
            this.broadcast(2);
        }
        return this;
    }

    @Override
    public float getValue() {
        return PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal);
    }

    public Slider shuffle() {
        float f = (float)Math.random();
        this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public Slider setScrollSensitivity(float f) {
        this.scrollSensitivity = f;
        return this;
    }

    @ControlP5.Invisible
    public Slider scrolled(int n) {
        if (this.isVisible) {
            float f = this._myValue;
            float f2 = this.isSnapToTickMarks ? 1.0f / (float)this.getNumberOfTickMarks() : this.scrollSensitivity * 0.1f;
            this.setValue(PApplet.map((float)(f += (this._myMax - this._myMin) * ((float)(-n) * f2)), (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
            if (this.triggerId == 2) {
                this.broadcast(2);
            }
        }
        return this;
    }

    @Override
    public Slider update() {
        return this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
    }

    @Override
    public Slider setMin(float f) {
        float f2 = this.getValue();
        this._myMinReal = f;
        this._myValue = PApplet.map((float)f2, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setMax(float f) {
        float f2 = this.getValue();
        this._myMaxReal = f;
        this._myValue = PApplet.map((float)f2, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public float getMin() {
        return this._myMinReal;
    }

    @Override
    public float getMax() {
        return this._myMaxReal;
    }

    public Slider setRange(float f, float f2) {
        float f3 = this._myInternalValue;
        this._myMinReal = f;
        this._myMaxReal = f2;
        this._myValue = PApplet.map((float)f3, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setWidth(int n) {
        super.setWidth(n);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setHeight(int n) {
        super.setHeight(n);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setSize(int n, int n2) {
        super.setWidth(n);
        this.setHeight(n2);
        this._myView = this.getWidth() > this.getHeight() ? new SliderViewH() : new SliderViewV();
        return this;
    }

    protected Slider setTickMarks() {
        return this;
    }

    public Slider setNumberOfTickMarks(int n) {
        this._myTickMarks.clear();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
            this.showTickMarks(true);
            this.snapToTickMarks(true);
            this.setHandleSize(20);
        } else {
            this.showTickMarks(false);
            this.snapToTickMarks(false);
            this.setHandleSize(this._myDefaultHandleSize);
        }
        this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public int getNumberOfTickMarks() {
        return this._myTickMarks.size();
    }

    public Slider showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
        return this;
    }

    public Slider snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
        return this;
    }

    public TickMark getTickMark(int n) {
        if (n >= 0 && n < this._myTickMarks.size()) {
            return this._myTickMarks.get(n);
        }
        return null;
    }

    public ArrayList<TickMark> getTickMarks() {
        return this._myTickMarks;
    }

    @Override
    @ControlP5.Invisible
    public Slider linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this;
    }

    public Slider setColorTickMark(int n) {
        this._myColorTickMark = n;
        return this;
    }

    public int getDirection() {
        return this._myView instanceof SliderViewH ? 0 : 1;
    }

    @Override
    @ControlP5.Invisible
    public Slider updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = this.getWidth() > this.getHeight() ? new SliderViewH() : new SliderViewV();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return this;
    }

    @Deprecated
    public void setSliderBarSize(int n) {
        this._myDefaultHandleSize = n;
        this.setSliderMode(this._mySliderMode);
    }

    @Deprecated
    public Slider setSensitivity(float f) {
        return this.setScrollSensitivity(f);
    }

    private class SliderViewH
    extends SliderView {
        SliderViewH() {
            Slider.this._myCaptionLabel.align(11, 3);
            Slider.this._myValueLabel.set("" + Slider.this.adjustValue(Slider.this.getValue())).align(37, 3);
        }

        @Override
        void setSnapValue() {
            float f = PApplet.round((float)PApplet.map((float)Slider.this._myValuePosition, (float)0.0f, (float)Slider.this.getWidth(), (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1)));
            Slider.this._myValue = PApplet.map((float)f, (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1), (float)Slider.this._myMin, (float)Slider.this._myMax);
        }

        @Override
        void updateUnit() {
            Slider.this._myUnit = (Slider.this._myMax - Slider.this._myMin) / (float)(Slider.this.getWidth() - Slider.this._myHandleSize);
        }

        @Override
        void update() {
            float f = Slider.this._myMin + ((float)Slider.this._myControlWindow.mouseX - (Controller.x(Slider.this._myParent.getAbsolutePosition()) + Controller.x(Slider.this.position))) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        @Override
        void updateInternalEvents(PApplet pApplet) {
            float f = Slider.this._myMin + ((float)Slider.this._myControlWindow.mouseX - (Controller.x(Slider.this._myParent.getAbsolutePosition()) + Controller.x(Slider.this.position))) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        @Override
        public void display(PGraphics pGraphics, Slider slider) {
            pGraphics.fill(Slider.this.getColor().getBackground());
            pGraphics.noStroke();
            if ((Slider.this.getColor().getBackground() >> 24 & 0xFF) > 0) {
                pGraphics.rect(0.0f, 0.0f, (float)Slider.this.getWidth(), (float)Slider.this.getHeight());
            }
            pGraphics.fill(Slider.this.getIsInside() ? Slider.this.getColor().getActive() : Slider.this.getColor().getForeground());
            if (Slider.this.getSliderMode() == 1) {
                pGraphics.rect(0.0f, 0.0f, Slider.this.getValuePosition(), (float)Slider.this.getHeight());
            } else if (Slider.this.isShowTickMarks) {
                pGraphics.triangle(Slider.this.getValuePosition(), 0.0f, Slider.this.getValuePosition() + (float)Slider.this.getHandleSize(), 0.0f, Slider.this.getValuePosition() + (float)(Slider.this._myHandleSize / 2), (float)Slider.this.getHeight());
            } else {
                pGraphics.rect(Slider.this.getValuePosition(), 0.0f, (float)Slider.this.getHandleSize(), (float)Slider.this.getHeight());
            }
            pGraphics.fill(255);
            if (Slider.this.isLabelVisible) {
                Slider.this.getValueLabel().draw(pGraphics, 0, 0, slider);
                Slider.this.getCaptionLabel().draw(pGraphics, 0, 0, slider);
            }
            if (Slider.this.isShowTickMarks) {
                pGraphics.pushMatrix();
                pGraphics.translate(Slider.this.getSliderMode() == 1 ? 0.0f : (float)(Slider.this.getHandleSize() / 2), (float)Slider.this.getHeight());
                pGraphics.fill(Slider.this._myColorTickMark);
                pGraphics.noStroke();
                float f = (Slider.this.getWidth() - (Slider.this.getSliderMode() == 1 ? 0 : Slider.this.getHandleSize())) / (Slider.this.getTickMarks().size() - 1);
                for (TickMark tickMark : Slider.this.getTickMarks()) {
                    tickMark.draw(pGraphics, Slider.this.getDirection());
                    pGraphics.translate(f, 0.0f);
                }
                pGraphics.popMatrix();
            }
        }
    }

    private class SliderViewV
    extends SliderView {
        SliderViewV() {
            Slider.this._myCaptionLabel.align(37, 13).setPadding(0, Label.paddingY);
            Slider.this._myValueLabel.set("" + Slider.this.adjustValue(Slider.this.getValue())).align(11, 101);
        }

        @Override
        void setSnapValue() {
            float f = PApplet.round((float)PApplet.map((float)Slider.this._myValuePosition, (float)0.0f, (float)Slider.this.getHeight(), (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1)));
            Slider.this._myValue = PApplet.map((float)f, (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1), (float)Slider.this._myMin, (float)Slider.this._myMax);
        }

        @Override
        void updateUnit() {
            Slider.this._myUnit = (Slider.this._myMax - Slider.this._myMin) / (float)(Slider.this.getHeight() - Slider.this._myHandleSize);
        }

        @Override
        void update() {
            float f = Slider.this._myMin + -((float)Slider.this._myControlWindow.mouseY - (Controller.y(Slider.this._myParent.getAbsolutePosition()) + Controller.y(Slider.this.position)) - (float)Slider.this.getHeight()) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        @Override
        void updateInternalEvents(PApplet pApplet) {
            float f = Slider.this._myMin + -((float)Slider.this._myControlWindow.mouseY - (Controller.y(Slider.this._myParent.getAbsolutePosition()) + Controller.y(Slider.this.position)) - (float)Slider.this.getHeight()) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        @Override
        public void display(PGraphics pGraphics, Slider slider) {
            pGraphics.fill(Slider.this.getColor().getBackground());
            pGraphics.noStroke();
            if ((Slider.this.getColor().getBackground() >> 24 & 0xFF) > 0) {
                pGraphics.rect(0.0f, 0.0f, (float)Slider.this.getWidth(), (float)Slider.this.getHeight());
            }
            pGraphics.fill(Slider.this.getIsInside() ? Slider.this.getColor().getActive() : Slider.this.getColor().getForeground());
            if (Slider.this.getSliderMode() == 1) {
                pGraphics.rect(0.0f, (float)Slider.this.getHeight(), (float)Slider.this.getWidth(), -Slider.this.getValuePosition());
            } else if (Slider.this.isShowTickMarks) {
                pGraphics.triangle((float)Slider.this.getWidth(), (float)Slider.this.getHeight() - Slider.this.getValuePosition(), (float)Slider.this.getWidth(), (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)Slider.this.getHandleSize(), 0.0f, (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)(Slider.this.getHandleSize() / 2));
            } else {
                pGraphics.rect(0.0f, (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)Slider.this.getHandleSize(), (float)Slider.this.getWidth(), (float)Slider.this.getHandleSize());
            }
            if (Slider.this.isLabelVisible) {
                Slider.this.getCaptionLabel().draw(pGraphics, 0, 0, slider);
                pGraphics.pushMatrix();
                pGraphics.translate(0.0f, (float)((int)PApplet.map((float)Slider.this._myValue, (float)Slider.this._myMax, (float)Slider.this._myMin, (float)0.0f, (float)(Slider.this.getHeight() - Slider.this._myValueLabel.getHeight()))));
                Slider.this.getValueLabel().draw(pGraphics, 0, 0, slider);
                pGraphics.popMatrix();
            }
            if (Slider.this.isShowTickMarks) {
                pGraphics.pushMatrix();
                pGraphics.pushStyle();
                pGraphics.translate(-4.0f, Slider.this.getSliderMode() == 1 ? 0.0f : (float)(Slider.this.getHandleSize() / 2));
                pGraphics.fill(Slider.this._myColorTickMark);
                float f = (Slider.this.getHeight() - (Slider.this.getSliderMode() == 1 ? 0 : Slider.this.getHandleSize())) / (Slider.this.getTickMarks().size() - 1);
                for (TickMark tickMark : Slider.this.getTickMarks()) {
                    tickMark.draw(pGraphics, Slider.this.getDirection());
                    pGraphics.translate(0.0f, f);
                }
                pGraphics.popStyle();
                pGraphics.popMatrix();
            }
        }
    }

    private abstract class SliderView
    implements ControllerView<Slider> {
        private SliderView() {
        }

        abstract void updateInternalEvents(PApplet var1);

        abstract void update();

        abstract void updateUnit();

        abstract void setSnapValue();
    }
}

