/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.analyzer.raster;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterAnalyzer_Histogram {
    protected ICreateHistogramImpl _histImpl;
    protected int _vertical_skip;

    public NyARRasterAnalyzer_Histogram(int i_raster_format, int i_vertical_interval) throws NyARException {
        if (!this.initInstance(i_raster_format, i_vertical_interval)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_raster_format, int i_vertical_interval) {
        switch (i_raster_format) {
            case 65537: 
            case 65538: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24();
                break;
            }
            case 262145: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8();
                break;
            }
            case 65793: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32();
                break;
            }
            case 65794: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32();
                break;
            }
            case 197121: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE();
                break;
            }
            case 262402: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32();
                break;
            }
            default: {
                return false;
            }
        }
        this._vertical_skip = i_vertical_interval;
        return true;
    }

    public void setVerticalInterval(int i_step) {
        assert (this._vertical_skip > 0);
        this._vertical_skip = i_step;
    }

    public void analyzeRaster(INyARRaster i_input, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize size = i_input.getSize();
        assert (size.w * size.h < 0x40000000);
        assert (o_histogram.length == 256);
        int[] h = o_histogram.data;
        int i = o_histogram.length - 1;
        while (i >= 0) {
            h[i] = 0;
            --i;
        }
        o_histogram.total_of_data = size.w * size.h / this._vertical_skip;
        this._histImpl.createHistogram(i_input, 0, 0, size.w, size.h, o_histogram.data, this._vertical_skip);
    }

    public void analyzeRaster(INyARRaster i_input, NyARIntRect i_area, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize size = i_input.getSize();
        assert (size.w * size.h < 0x40000000);
        assert (o_histogram.length == 256);
        int[] h = o_histogram.data;
        int i = o_histogram.length - 1;
        while (i >= 0) {
            h[i] = 0;
            --i;
        }
        o_histogram.total_of_data = i_area.w * i_area.h / this._vertical_skip;
        this._histImpl.createHistogram(i_input, i_area.x, i_area.y, i_area.w, i_area.h, o_histogram.data, this._vertical_skip);
    }

    public static void main(String[] args) {
        try {
            NyARRgbRaster raster = new NyARRgbRaster(100, 100, 197121);
            short[] buf = (short[])raster.getBuffer();
            int i = 0;
            while (i < 100) {
                int i2 = 0;
                while (i2 < 100) {
                    buf[i * 100 + i2 + 0] = 3;
                    ++i2;
                }
                ++i;
            }
            NyARIntRect rect = new NyARIntRect();
            rect.x = 2;
            rect.y = 2;
            rect.h = 10;
            rect.w = 10;
            NyARRasterAnalyzer_Histogram ha = new NyARRasterAnalyzer_Histogram(raster.getBufferType(), 1);
            NyARHistogram h = new NyARHistogram(256);
            ha.analyzeRaster(raster, rect, h);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected static interface ICreateHistogramImpl {
        public void createHistogram(INyARRaster var1, int var2, int var3, int var4, int var5, int[] var6, int var7);
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(65793));
            byte[] input = (byte[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = (i_skip * s.w - i_w) * 4;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = (i_t * s.w + i_l) * 4;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 4;
                    --x;
                }
                while (x >= 0) {
                    int n = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = ((input[(pt += 4) + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 4;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(65538) || i_raster.isEqualBufferType(65537));
            byte[] input = (byte[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = (i_skip * s.w - i_w) * 3;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = (i_t * s.w + i_l) * 3;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 3;
                    --x;
                }
                while (x >= 0) {
                    int n = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 24;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(65794));
            byte[] input = (byte[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = (i_skip * s.w - i_w) * 4;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = (i_t * s.w + i_l) * 4;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = ((input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 4;
                    --x;
                }
                while (x >= 0) {
                    int n = ((input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = ((input[(pt += 4) + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 4;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(262145));
            int[] input = (int[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = i_skip * s.w - i_w;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = i_t * s.w + i_l;
            int y = i_h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = input[pt++];
                    o_histogram[n] = o_histogram[n] + 1;
                    --x;
                }
                while (x >= 0) {
                    int n = input[pt++];
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = input[pt++];
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = input[pt++];
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = input[pt++];
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = input[pt++];
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = input[pt++];
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = input[pt++];
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = input[pt++];
                    o_histogram[n8] = o_histogram[n8] + 1;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(262402));
            int[] input = (int[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = i_skip * s.w - i_w;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = i_t * s.w + i_l;
            int y = i_h - 1;
            while (y >= 0) {
                int v;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt++];
                    int n = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt++];
                    int n = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    v = input[pt++];
                    int n2 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    v = input[pt++];
                    int n3 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    v = input[pt++];
                    int n4 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    v = input[pt++];
                    int n5 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    v = input[pt++];
                    int n6 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    v = input[pt++];
                    int n7 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    v = input[pt++];
                    int n8 = ((v & 0xFF) + (v & 0xFF) + (v & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE() {
        }

        @Override
        public void createHistogram(INyARRaster i_raster, int i_l, int i_t, int i_w, int i_h, int[] o_histogram, int i_skip) {
            assert (i_raster.isEqualBufferType(197121));
            short[] input = (short[])i_raster.getBuffer();
            NyARIntSize s = i_raster.getSize();
            int skip = i_skip * s.w - i_w;
            int pix_count = i_w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt = i_t * s.w + i_l;
            int y = i_h - 1;
            while (y >= 0) {
                short v;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt++];
                    int n = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt++];
                    int n = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    v = input[pt++];
                    int n2 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    v = input[pt++];
                    int n3 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    v = input[pt++];
                    int n4 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    v = input[pt++];
                    int n5 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    v = input[pt++];
                    int n6 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    v = input[pt++];
                    int n7 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    v = input[pt++];
                    int n8 = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    x -= 8;
                }
                pt += skip;
                y -= i_skip;
            }
        }
    }
}

