/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster.rgb;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_BYTE1D_B8G8R8X8_32;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_BYTE1D_B8G8R8_24;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_BYTE1D_R8G8B8_24;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_BYTE1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_INT1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_WORD1D_R5G6B5_16LE;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbRaster
extends NyARRgbRaster_BasicClass {
    protected Object _buf;
    protected INyARRgbPixelReader _reader;
    protected boolean _is_attached_buffer;

    public NyARRgbRaster(int i_width, int i_height, int i_raster_type, boolean i_is_alloc) throws NyARException {
        super(i_width, i_height, i_raster_type);
        if (!this.initInstance(this._size, i_raster_type, i_is_alloc)) {
            throw new NyARException();
        }
    }

    public NyARRgbRaster(int i_width, int i_height, int i_raster_type) throws NyARException {
        super(i_width, i_height, i_raster_type);
        if (!this.initInstance(this._size, i_raster_type, true)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(NyARIntSize i_size, int i_raster_type, boolean i_is_alloc) {
        switch (i_raster_type) {
            case 262402: {
                this._buf = i_is_alloc ? new int[i_size.w * i_size.h] : null;
                this._reader = new NyARRgbPixelReader_INT1D_X8R8G8B8_32((int[])this._buf, i_size);
                break;
            }
            case 65793: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 4] : null;
                this._reader = new NyARRgbPixelReader_BYTE1D_B8G8R8X8_32((byte[])this._buf, i_size);
                break;
            }
            case 65537: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 3] : null;
                this._reader = new NyARRgbPixelReader_BYTE1D_R8G8B8_24((byte[])this._buf, i_size);
                break;
            }
            case 65538: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 3] : null;
                this._reader = new NyARRgbPixelReader_BYTE1D_B8G8R8_24((byte[])this._buf, i_size);
                break;
            }
            case 65794: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 4] : null;
                this._reader = new NyARRgbPixelReader_BYTE1D_X8R8G8B8_32((byte[])this._buf, i_size);
                break;
            }
            case 197121: {
                this._buf = i_is_alloc ? new short[i_size.w * i_size.h] : null;
                this._reader = new NyARRgbPixelReader_WORD1D_R5G6B5_16LE((short[])this._buf, i_size);
                break;
            }
            default: {
                return false;
            }
        }
        this._is_attached_buffer = i_is_alloc;
        return true;
    }

    @Override
    public INyARRgbPixelReader getRgbPixelReader() throws NyARException {
        return this._reader;
    }

    @Override
    public Object getBuffer() {
        return this._buf;
    }

    @Override
    public boolean hasBuffer() {
        return this._buf != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        assert (!this._is_attached_buffer);
        this._buf = i_ref_buf;
        this._reader.switchBuffer(i_ref_buf);
    }
}

