/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.labeling;

import java.lang.reflect.Array;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelInfo;

public class NyARLabelOverlapChecker<T extends NyARLabelInfo> {
    private T[] _labels;
    private int _length;
    private Class<T> _element_type;

    public NyARLabelOverlapChecker(int i_max_label, Class<T> i_element_type) {
        this._element_type = i_element_type;
        this._labels = (NyARLabelInfo[])Array.newInstance(i_element_type, i_max_label);
    }

    public void push(T i_label_ref) {
        this._labels[this._length] = i_label_ref;
        ++this._length;
    }

    public boolean check(T i_label) {
        T[] label_pt = this._labels;
        int px1 = (int)((NyARLabelInfo)i_label).pos_x;
        int py1 = (int)((NyARLabelInfo)i_label).pos_y;
        int i = this._length - 1;
        while (i >= 0) {
            int px2 = (int)((NyARLabelInfo)label_pt[i]).pos_x;
            int py2 = (int)((NyARLabelInfo)label_pt[i]).pos_y;
            int d = (px1 - px2) * (px1 - px2) + (py1 - py2) * (py1 - py2);
            if (d < ((NyARLabelInfo)label_pt[i]).area / 4) {
                return false;
            }
            --i;
        }
        return true;
    }

    public void setMaxLabels(int i_max_label) {
        if (i_max_label > this._labels.length) {
            this._labels = (NyARLabelInfo[])Array.newInstance(this._element_type, i_max_label);
        }
        this._length = 0;
    }
}

