/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.IPickupRasterImpl;

final class PPickup_Impl_AnyRaster
implements IPickupRasterImpl {
    private final int[] __pickFromRaster_rgb_tmp = new int[3];

    PPickup_Impl_AnyRaster() {
    }

    @Override
    public void onePixel(int pk_l, int pk_t, double[] cpara, INyARRgbRaster i_in_raster, INyARRgbRaster o_out) throws NyARException {
        switch (o_out.getBufferType()) {
            case 262402: {
                this.onePixel_INT1D_X8R8G8B8_32(pk_l, pk_t, i_in_raster.getWidth(), i_in_raster.getHeight(), cpara, i_in_raster.getRgbPixelReader(), o_out);
                break;
            }
            default: {
                this.onePixel_ANY(pk_l, pk_t, i_in_raster.getWidth(), i_in_raster.getHeight(), cpara, i_in_raster.getRgbPixelReader(), o_out);
            }
        }
    }

    @Override
    public void multiPixel(int pk_l, int pk_t, double[] cpara, int i_resolution, INyARRgbRaster i_in_raster, INyARRgbRaster o_out) throws NyARException {
        switch (o_out.getBufferType()) {
            case 262402: {
                this.multiPixel_INT1D_X8R8G8B8_32(pk_l, pk_t, i_in_raster.getWidth(), i_in_raster.getHeight(), i_resolution, cpara, i_in_raster.getRgbPixelReader(), o_out);
                break;
            }
            default: {
                this.multiPixel_ANY(pk_l, pk_t, i_in_raster.getWidth(), i_in_raster.getHeight(), i_resolution, cpara, i_in_raster.getRgbPixelReader(), o_out);
            }
        }
    }

    private void onePixel_INT1D_X8R8G8B8_32(int pk_l, int pk_t, int in_w, int in_h, double[] cpara, INyARRgbPixelReader i_in_reader, INyARRgbRaster o_out) throws NyARException {
        assert (o_out.isEqualBufferType(262402));
        int[] rgb_tmp = this.__pickFromRaster_rgb_tmp;
        int[] pat_data = (int[])o_out.getBuffer();
        double cp0 = cpara[0];
        double cp3 = cpara[3];
        double cp6 = cpara[6];
        double cp1 = cpara[1];
        double cp4 = cpara[4];
        double cp7 = cpara[7];
        int out_w = o_out.getWidth();
        int out_h = o_out.getHeight();
        double cp7_cy_1 = cp7 * (double)pk_t + 1.0 + cp6 * (double)pk_l;
        double cp1_cy_cp2 = cp1 * (double)pk_t + cpara[2] + cp0 * (double)pk_l;
        double cp4_cy_cp5 = cp4 * (double)pk_t + cpara[5] + cp3 * (double)pk_l;
        int p = 0;
        int iy = out_h - 1;
        while (iy >= 0) {
            double cp7_cy_1_cp6_cx = cp7_cy_1;
            double cp1_cy_cp2_cp0_cx = cp1_cy_cp2;
            double cp4_cy_cp5_cp3_cx = cp4_cy_cp5;
            int ix = out_w - 1;
            while (ix >= 0) {
                double d = 1.0 / cp7_cy_1_cp6_cx;
                int x = (int)(cp1_cy_cp2_cp0_cx * d);
                int y = (int)(cp4_cy_cp5_cp3_cx * d);
                if (x < 0) {
                    x = 0;
                } else if (x >= in_w) {
                    x = in_w - 1;
                }
                if (y < 0) {
                    y = 0;
                } else if (y >= in_h) {
                    y = in_h - 1;
                }
                i_in_reader.getPixel(x, y, rgb_tmp);
                cp7_cy_1_cp6_cx += cp6;
                cp1_cy_cp2_cp0_cx += cp0;
                cp4_cy_cp5_cp3_cx += cp3;
                pat_data[p] = rgb_tmp[0] << 16 | rgb_tmp[1] << 8 | rgb_tmp[2] & 0xFF;
                ++p;
                --ix;
            }
            cp7_cy_1 += cp7;
            cp1_cy_cp2 += cp1;
            cp4_cy_cp5 += cp4;
            --iy;
        }
    }

    private void onePixel_ANY(int pk_l, int pk_t, int in_w, int in_h, double[] cpara, INyARRgbPixelReader i_in_reader, INyARRgbRaster o_out) throws NyARException {
        int[] rgb_tmp = this.__pickFromRaster_rgb_tmp;
        INyARRgbPixelReader out_reader = o_out.getRgbPixelReader();
        double cp0 = cpara[0];
        double cp3 = cpara[3];
        double cp6 = cpara[6];
        double cp1 = cpara[1];
        double cp4 = cpara[4];
        double cp7 = cpara[7];
        int out_w = o_out.getWidth();
        int out_h = o_out.getHeight();
        double cp7_cy_1 = cp7 * (double)pk_t + 1.0 + cp6 * (double)pk_l;
        double cp1_cy_cp2 = cp1 * (double)pk_t + cpara[2] + cp0 * (double)pk_l;
        double cp4_cy_cp5 = cp4 * (double)pk_t + cpara[5] + cp3 * (double)pk_l;
        int iy = 0;
        while (iy < out_h) {
            double cp7_cy_1_cp6_cx = cp7_cy_1;
            double cp1_cy_cp2_cp0_cx = cp1_cy_cp2;
            double cp4_cy_cp5_cp3_cx = cp4_cy_cp5;
            int ix = 0;
            while (ix < out_w) {
                double d = 1.0 / cp7_cy_1_cp6_cx;
                int x = (int)(cp1_cy_cp2_cp0_cx * d);
                int y = (int)(cp4_cy_cp5_cp3_cx * d);
                if (x < 0) {
                    x = 0;
                } else if (x >= in_w) {
                    x = in_w - 1;
                }
                if (y < 0) {
                    y = 0;
                } else if (y >= in_h) {
                    y = in_h - 1;
                }
                i_in_reader.getPixel(x, y, rgb_tmp);
                cp7_cy_1_cp6_cx += cp6;
                cp1_cy_cp2_cp0_cx += cp0;
                cp4_cy_cp5_cp3_cx += cp3;
                out_reader.setPixel(ix, iy, rgb_tmp);
                ++ix;
            }
            cp7_cy_1 += cp7;
            cp1_cy_cp2 += cp1;
            cp4_cy_cp5 += cp4;
            ++iy;
        }
    }

    private void multiPixel_INT1D_X8R8G8B8_32(int pk_l, int pk_t, int in_w, int in_h, int i_resolution, double[] cpara, INyARRgbPixelReader i_in_reader, INyARRgbRaster o_out) throws NyARException {
        assert (o_out.isEqualBufferType(262402));
        int res_pix = i_resolution * i_resolution;
        int[] rgb_tmp = this.__pickFromRaster_rgb_tmp;
        int[] pat_data = (int[])o_out.getBuffer();
        double cp0 = cpara[0];
        double cp3 = cpara[3];
        double cp6 = cpara[6];
        double cp1 = cpara[1];
        double cp4 = cpara[4];
        double cp7 = cpara[7];
        double cp2 = cpara[2];
        double cp5 = cpara[5];
        int out_w = o_out.getWidth();
        int out_h = o_out.getHeight();
        int p = out_w * out_h - 1;
        int iy = out_h - 1;
        while (iy >= 0) {
            int ix = out_w - 1;
            while (ix >= 0) {
                int b = 0;
                int g = 0;
                int r = 0;
                int cy = pk_t + iy * i_resolution;
                int cx = pk_l + ix * i_resolution;
                double cp7_cy_1_cp6_cx_b = cp7 * (double)cy + 1.0 + cp6 * (double)cx;
                double cp1_cy_cp2_cp0_cx_b = cp1 * (double)cy + cp2 + cp0 * (double)cx;
                double cp4_cy_cp5_cp3_cx_b = cp4 * (double)cy + cp5 + cp3 * (double)cx;
                int i2y = i_resolution - 1;
                while (i2y >= 0) {
                    double cp7_cy_1_cp6_cx = cp7_cy_1_cp6_cx_b;
                    double cp1_cy_cp2_cp0_cx = cp1_cy_cp2_cp0_cx_b;
                    double cp4_cy_cp5_cp3_cx = cp4_cy_cp5_cp3_cx_b;
                    int i2x = i_resolution - 1;
                    while (i2x >= 0) {
                        double d = 1.0 / cp7_cy_1_cp6_cx;
                        int x = (int)(cp1_cy_cp2_cp0_cx * d);
                        int y = (int)(cp4_cy_cp5_cp3_cx * d);
                        if (x < 0) {
                            x = 0;
                        } else if (x >= in_w) {
                            x = in_w - 1;
                        }
                        if (y < 0) {
                            y = 0;
                        } else if (y >= in_h) {
                            y = in_h - 1;
                        }
                        i_in_reader.getPixel(x, y, rgb_tmp);
                        r += rgb_tmp[0];
                        g += rgb_tmp[1];
                        b += rgb_tmp[2];
                        cp7_cy_1_cp6_cx += cp6;
                        cp1_cy_cp2_cp0_cx += cp0;
                        cp4_cy_cp5_cp3_cx += cp3;
                        --i2x;
                    }
                    cp7_cy_1_cp6_cx_b += cp7;
                    cp1_cy_cp2_cp0_cx_b += cp1;
                    cp4_cy_cp5_cp3_cx_b += cp4;
                    --i2y;
                }
                pat_data[p] = ((r /= res_pix) & 0xFF) << 16 | ((g /= res_pix) & 0xFF) << 8 | (b /= res_pix) & 0xFF;
                --p;
                --ix;
            }
            --iy;
        }
    }

    private void multiPixel_ANY(int pk_l, int pk_t, int in_w, int in_h, int i_resolution, double[] cpara, INyARRgbPixelReader i_in_reader, INyARRgbRaster o_out) throws NyARException {
        int res_pix = i_resolution * i_resolution;
        int[] rgb_tmp = this.__pickFromRaster_rgb_tmp;
        INyARRgbPixelReader out_reader = o_out.getRgbPixelReader();
        double cp0 = cpara[0];
        double cp3 = cpara[3];
        double cp6 = cpara[6];
        double cp1 = cpara[1];
        double cp4 = cpara[4];
        double cp7 = cpara[7];
        double cp2 = cpara[2];
        double cp5 = cpara[5];
        int out_w = o_out.getWidth();
        int out_h = o_out.getHeight();
        int iy = out_h - 1;
        while (iy >= 0) {
            int ix = out_w - 1;
            while (ix >= 0) {
                int b = 0;
                int g = 0;
                int r = 0;
                int cy = pk_t + iy * i_resolution;
                int cx = pk_l + ix * i_resolution;
                double cp7_cy_1_cp6_cx_b = cp7 * (double)cy + 1.0 + cp6 * (double)cx;
                double cp1_cy_cp2_cp0_cx_b = cp1 * (double)cy + cp2 + cp0 * (double)cx;
                double cp4_cy_cp5_cp3_cx_b = cp4 * (double)cy + cp5 + cp3 * (double)cx;
                int i2y = i_resolution - 1;
                while (i2y >= 0) {
                    double cp7_cy_1_cp6_cx = cp7_cy_1_cp6_cx_b;
                    double cp1_cy_cp2_cp0_cx = cp1_cy_cp2_cp0_cx_b;
                    double cp4_cy_cp5_cp3_cx = cp4_cy_cp5_cp3_cx_b;
                    int i2x = i_resolution - 1;
                    while (i2x >= 0) {
                        double d = 1.0 / cp7_cy_1_cp6_cx;
                        int x = (int)(cp1_cy_cp2_cp0_cx * d);
                        int y = (int)(cp4_cy_cp5_cp3_cx * d);
                        if (x < 0) {
                            x = 0;
                        } else if (x >= in_w) {
                            x = in_w - 1;
                        }
                        if (y < 0) {
                            y = 0;
                        } else if (y >= in_h) {
                            y = in_h - 1;
                        }
                        i_in_reader.getPixel(x, y, rgb_tmp);
                        r += rgb_tmp[0];
                        g += rgb_tmp[1];
                        b += rgb_tmp[2];
                        cp7_cy_1_cp6_cx += cp6;
                        cp1_cy_cp2_cp0_cx += cp0;
                        cp4_cy_cp5_cp3_cx += cp3;
                        --i2x;
                    }
                    cp7_cy_1_cp6_cx_b += cp7;
                    cp1_cy_cp2_cp0_cx_b += cp1;
                    cp4_cy_cp5_cp3_cx_b += cp4;
                    --i2y;
                }
                out_reader.setPixel(ix, iy, r / res_pix, g / res_pix, b / res_pix);
                --ix;
            }
            --iy;
        }
    }
}

