/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;

public class NyARDoublePoint2d {
    public double x;
    public double y;

    public static NyARDoublePoint2d[] createArray(int i_number) {
        NyARDoublePoint2d[] ret = new NyARDoublePoint2d[i_number];
        int i = 0;
        while (i < i_number) {
            ret[i] = new NyARDoublePoint2d();
            ++i;
        }
        return ret;
    }

    public static NyARDoublePoint2d[][] create2dArray(int i_length_x, int i_length_y) {
        NyARDoublePoint2d[][] ret = new NyARDoublePoint2d[i_length_y][i_length_x];
        int i = 0;
        while (i < i_length_y) {
            int i2 = 0;
            while (i2 < i_length_x) {
                ret[i][i2] = new NyARDoublePoint2d();
                ++i2;
            }
            ++i;
        }
        return ret;
    }

    public static final double crossProduct3Point(NyARDoublePoint2d p1, NyARDoublePoint2d p2, NyARDoublePoint2d p3) {
        return (p2.x - p1.x) * (p3.y - p2.y) - (p2.y - p1.y) * (p3.x - p2.x);
    }

    public static final double crossProduct3Point(NyARDoublePoint2d p1, NyARDoublePoint2d p2, double p3_x, double p3_y) {
        return (p2.x - p1.x) * (p3_y - p2.y) - (p2.y - p1.y) * (p3_x - p2.x);
    }

    public static final void makeCenter(NyARDoublePoint2d[] i_points, int i_number_of_data, NyARDoublePoint2d o_out) {
        double y = 0.0;
        double x = 0.0;
        int i = i_number_of_data - 1;
        while (i >= 0) {
            x += i_points[i].x;
            y += i_points[i].y;
            --i;
        }
        o_out.x = x / (double)i_number_of_data;
        o_out.x = y / (double)i_number_of_data;
    }

    public static final void makeCenter(NyARDoublePoint2d[] i_points, int i_number_of_data, NyARIntPoint2d o_out) {
        double ly = 0.0;
        double lx = 0.0;
        int i = i_number_of_data - 1;
        while (i >= 0) {
            lx += i_points[i].x;
            ly += i_points[i].y;
            --i;
        }
        o_out.x = (int)(lx / (double)i_number_of_data);
        o_out.y = (int)(ly / (double)i_number_of_data);
    }

    public NyARDoublePoint2d() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public NyARDoublePoint2d(double i_x, double i_y) {
        this.x = i_x;
        this.y = i_y;
    }

    public NyARDoublePoint2d(NyARDoublePoint2d i_src) {
        this.x = i_src.x;
        this.y = i_src.y;
    }

    public NyARDoublePoint2d(NyARIntPoint2d i_src) {
        this.x = i_src.x;
        this.y = i_src.y;
    }

    public final double sqDist(NyARDoublePoint2d i_p1) {
        double x = this.x - i_p1.x;
        double y = this.y - i_p1.y;
        return x * x + y * y;
    }

    public final double sqDist(NyARIntPoint2d i_p1) {
        double x = this.x - (double)i_p1.x;
        double y = this.y - (double)i_p1.y;
        return x * x + y * y;
    }

    public final void setValue(NyARDoublePoint2d i_src) {
        this.x = i_src.x;
        this.y = i_src.y;
    }

    public final void setValue(NyARIntPoint2d i_src) {
        this.x = i_src.x;
        this.y = i_src.y;
    }

    public final void setValue(double i_x, double i_y) {
        this.x = i_x;
        this.y = i_y;
    }
}

