/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.types;

import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARVecLinear2d;

public class NyARLinear {
    public double b;
    public double a;
    public double c;

    public static NyARLinear[] createArray(int i_number) {
        NyARLinear[] ret = new NyARLinear[i_number];
        int i = 0;
        while (i < i_number) {
            ret[i] = new NyARLinear();
            ++i;
        }
        return ret;
    }

    public final void copyFrom(NyARLinear i_source) {
        this.b = i_source.b;
        this.a = i_source.a;
        this.c = i_source.c;
    }

    public final boolean crossPos(NyARLinear l_line_2, NyARDoublePoint2d o_point) {
        double w1 = this.a * l_line_2.b - l_line_2.a * this.b;
        if (w1 == 0.0) {
            return false;
        }
        o_point.x = (this.b * l_line_2.c - l_line_2.b * this.c) / w1;
        o_point.y = (l_line_2.a * this.c - this.a * l_line_2.c) / w1;
        return true;
    }

    public final boolean crossPos(double i_a, double i_b, double i_c, NyARDoublePoint2d o_point) {
        double w1 = this.a * i_b - i_a * this.b;
        if (w1 == 0.0) {
            return false;
        }
        o_point.x = (this.b * i_c - i_b * this.c) / w1;
        o_point.y = (i_a * this.c - this.a * i_c) / w1;
        return true;
    }

    public final boolean crossPos(double i_a, double i_b, double i_c, NyARIntPoint2d o_point) {
        double w1 = this.a * i_b - i_a * this.b;
        if (w1 == 0.0) {
            return false;
        }
        o_point.x = (int)((this.b * i_c - i_b * this.c) / w1);
        o_point.y = (int)((i_a * this.c - this.a * i_c) / w1);
        return true;
    }

    public final boolean isCross(NyARLinear l_line_2) {
        double w1 = this.a * l_line_2.b - l_line_2.a * this.b;
        return w1 != 0.0;
    }

    public final boolean makeLinearWithNormalize(NyARIntPoint2d i_point1, NyARIntPoint2d i_point2) {
        return this.makeLinearWithNormalize(i_point1.x, i_point1.y, i_point2.x, i_point2.y);
    }

    public final boolean makeLinearWithNormalize(NyARDoublePoint2d i_point1, NyARDoublePoint2d i_point2) {
        return this.makeLinearWithNormalize(i_point1.x, i_point1.y, i_point2.x, i_point2.y);
    }

    public final boolean makeLinearWithNormalize(double x1, double y1, double x2, double y2) {
        double dx = y2 - y1;
        double dy = x1 - x2;
        double sq = Math.sqrt(dx * dx + dy * dy);
        if (sq == 0.0) {
            return false;
        }
        sq = 1.0 / sq;
        this.a = dx * sq;
        this.b = dy * sq;
        this.c = (x1 * (y1 - y2) + y1 * (x2 - x1)) * sq;
        return true;
    }

    public final void setVector(double i_dx, double i_dy, double i_x, double i_y) {
        this.a = i_dy;
        this.b = -i_dx;
        this.c = i_dx * i_y - i_dy * i_x;
    }

    public final void setVector(NyARVecLinear2d i_vector) {
        this.a = i_vector.dy;
        this.b = -i_vector.dx;
        this.c = i_vector.dx * i_vector.y - i_vector.dy * i_vector.x;
    }

    public final boolean setVectorWithNormalize(NyARVecLinear2d i_vector) {
        double dx = i_vector.dx;
        double dy = i_vector.dy;
        double sq = Math.sqrt(dx * dx + dy * dy);
        if (sq == 0.0) {
            return false;
        }
        sq = 1.0 / sq;
        this.a = dy * sq;
        this.b = -dx * sq;
        this.c = -(this.a * i_vector.x + this.b * i_vector.y);
        return true;
    }

    public final void normalLine(double i_x, double i_y, NyARLinear i_linear) {
        double lb;
        double la = i_linear.a;
        this.a = lb = i_linear.b;
        this.b = -la;
        this.c = -(lb * i_x - la * i_y);
    }

    public final boolean normalLineCrossPos(double i_x, double i_y, NyARLinear i_linear, NyARDoublePoint2d o_point) {
        double la = this.b;
        double lb = -this.a;
        double lc = -(la * i_x + lb * i_y);
        double w1 = i_linear.a * lb - la * i_linear.b;
        if (w1 == 0.0) {
            return false;
        }
        o_point.x = (i_linear.b * lc - lb * i_linear.c) / w1;
        o_point.y = (la * i_linear.c - i_linear.a * lc) / w1;
        return true;
    }

    public final boolean makeSegmentLine(int i_width, int i_height, NyARIntPoint2d[] o_point) {
        int idx = 0;
        NyARIntPoint2d ptr = o_point[0];
        if (this.crossPos(0.0, -1.0, 0.0, ptr) && ptr.x >= 0 && ptr.x < i_width) {
            ptr = o_point[++idx];
        }
        if (this.crossPos(0.0, -1.0, (double)(i_height - 1), ptr) && ptr.x >= 0 && ptr.x < i_width) {
            if (++idx == 2) {
                return true;
            }
            ptr = o_point[idx];
        }
        if (this.crossPos(-1.0, 0.0, 0.0, ptr) && ptr.y >= 0 && ptr.y < i_height) {
            if (++idx == 2) {
                return true;
            }
            ptr = o_point[idx];
        }
        return this.crossPos(-1.0, 0.0, (double)(i_width - 1), ptr) && ptr.y >= 0 && ptr.y < i_height && ++idx == 2;
    }

    public final boolean makeSegmentLine(int i_left, int i_top, int i_width, int i_height, NyARIntPoint2d[] o_point) {
        int bottom = i_top + i_height;
        int right = i_left + i_width;
        int idx = 0;
        NyARIntPoint2d ptr = o_point[0];
        if (this.crossPos(0.0, -1.0, (double)i_top, ptr) && ptr.x >= i_left && ptr.x < right) {
            ptr = o_point[++idx];
        }
        if (this.crossPos(0.0, -1.0, (double)(bottom - 1), ptr) && ptr.x >= i_left && ptr.x < right) {
            if (++idx == 2) {
                return true;
            }
            ptr = o_point[idx];
        }
        if (this.crossPos(-1.0, 0.0, (double)i_left, ptr) && ptr.y >= i_top && ptr.y < bottom) {
            if (++idx == 2) {
                return true;
            }
            ptr = o_point[idx];
        }
        return this.crossPos(-1.0, 0.0, (double)(right - 1), ptr) && ptr.y >= i_top && ptr.y < bottom && ++idx == 2;
    }

    public final double sqDistBySegmentLineEdge(NyARDoublePoint2d i_sp1, NyARDoublePoint2d i_sp2) {
        double lb = -this.a;
        double la = this.b;
        double w1 = this.a * lb - la * this.b;
        if (w1 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double lc = -(la * i_sp1.x + lb * i_sp1.y);
        double x = (this.b * lc - lb * this.c) / w1 - i_sp1.x;
        double y = (la * this.c - this.a * lc) / w1 - i_sp1.y;
        double sqdist = x * x + y * y;
        lc = -(la * i_sp2.x + lb * i_sp2.y);
        x = (this.b * lc - lb * this.c) / w1 - i_sp2.x;
        y = (la * this.c - this.a * lc) / w1 - i_sp2.y;
        return sqdist + x * x + y * y;
    }

    public boolean leastSquares(NyARDoublePoint2d[] i_points, int i_number_of_data) {
        assert (i_number_of_data > 1);
        double sum_xy = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_x2 = 0.0;
        int i = 0;
        while (i < i_number_of_data) {
            NyARDoublePoint2d ptr = i_points[i];
            double xw = ptr.x;
            sum_xy += xw * ptr.y;
            sum_x += xw;
            sum_y += ptr.y;
            sum_x2 += xw * xw;
            ++i;
        }
        this.b = -((double)i_number_of_data * sum_x2 - sum_x * sum_x);
        this.a = (double)i_number_of_data * sum_xy - sum_x * sum_y;
        this.c = sum_x2 * sum_y - sum_xy * sum_x;
        return true;
    }
}

