/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;
import saito.objloader.Face;
import saito.objloader.OBJModel;
import saito.objloader.Segment;

public class OBJLoader_FaceDirection_MATTD
extends PApplet {
    OBJModel model;
    float rotX;
    float rotY;
    float normLength = -25.0f;
    PVector pos;

    public void setup() {
        this.size(600, 600, "processing.core.PGraphics3D");
        this.model = new OBJModel((PApplet)this, "cubic_sphere.obj", "relative", 16);
        this.model.scale(3.0f);
        this.model.translateToCenter();
        this.pos = new PVector();
    }

    public void draw() {
        this.background(32);
        this.lights();
        this.pos.x = OBJLoader_FaceDirection_MATTD.sin((float)OBJLoader_FaceDirection_MATTD.radians((float)this.frameCount)) * 200.0f;
        this.pos.y = OBJLoader_FaceDirection_MATTD.cos((float)OBJLoader_FaceDirection_MATTD.radians((float)this.frameCount)) * 200.0f;
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateX(this.rotY);
        this.rotateY(this.rotX);
        this.pushMatrix();
        this.drawPoint(this.pos);
        this.popMatrix();
        int n = 0;
        while (n < this.model.getSegmentCount()) {
            Segment segment = this.model.getSegment(n);
            Face[] faceArray = segment.getFaces();
            this.drawFaces(faceArray);
            this.drawNormals(faceArray);
            ++n;
        }
        this.popMatrix();
    }

    public void drawFaces(Face[] faceArray) {
        this.noStroke();
        this.beginShape(16);
        int n = 0;
        while (n < faceArray.length) {
            PVector[] pVectorArray = faceArray[n].getVertices();
            PVector[] pVectorArray2 = faceArray[n].getNormals();
            if (faceArray[n].isFacingPosition(this.pos)) {
                int n2 = 0;
                while (n2 < pVectorArray.length) {
                    this.normal(pVectorArray2[n2].x, pVectorArray2[n2].y, pVectorArray2[n2].z);
                    this.vertex(pVectorArray[n2].x, pVectorArray[n2].y, pVectorArray[n2].z);
                    ++n2;
                }
            }
            ++n;
        }
        this.endShape();
    }

    public void drawNormals(Face[] faceArray) {
        this.beginShape(4);
        int n = 0;
        while (n < faceArray.length) {
            PVector pVector = faceArray[n].getCenter();
            PVector pVector2 = faceArray[n].getNormal();
            this.stroke(255.0f, 0.0f, 255.0f, 255.0f * faceArray[n].getFacingAmount(this.pos));
            this.vertex(pVector.x, pVector.y, pVector.z);
            this.vertex(pVector.x + pVector2.x * this.normLength, pVector.y + pVector2.y * this.normLength, pVector.z + pVector2.z * this.normLength);
            ++n;
        }
        this.endShape();
    }

    public void drawPoint(PVector pVector) {
        this.translate(pVector.x, pVector.y, pVector.z);
        this.noStroke();
        this.ellipse(0.0f, 0.0f, 20.0f, 20.0f);
        this.rotateX(1.5707964f);
        this.ellipse(0.0f, 0.0f, 20.0f, 20.0f);
        this.rotateY(1.5707964f);
        this.ellipse(0.0f, 0.0f, 20.0f, 20.0f);
    }

    public void mouseDragged() {
        this.rotX += (float)(this.mouseX - this.pmouseX) * 0.01f;
        this.rotY -= (float)(this.mouseY - this.pmouseY) * 0.01f;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "OBJLoader_FaceDirection_MATTD"});
    }
}

