
/*

  Alycia Rainaud
  Premier test pour un programme webcam/control p5
  À améliorer = diversité des filtres
  
*/


import processing.video.*; //Importer la librairie video
import controlP5.*; // Importer la librairie controlP5 interfaces graphiques



// Initialisation des variables 

ControlP5 controlP5; // Déclarer la variable controlP5
Capture cam; // Déclarer la variable caméra
color c; // Déclarer la variable color

// Attributs des boutons control P5
int myColorBackground = color(0,0,0); // Couleur de fond de base
int knobValue = 100; // Valeur du bouton knob 1
int knobValue2 = 100; // Valeur du bouton knob 2
int knobValue3 = 100; // Valeur du bouton knob 3

Knob myKnobA; // Déclarer l'objet KnobA
Knob myKnobB; // Déclarer l'objet KnobB
Knob myKnobC; // Déclarer l'objet KnobC




// Initialisation des paramètres d'affichages

void setup() { 

  size(640,480); // Taille de la fenêtre d'affichage
  smooth(); // Lissage
  noStroke(); // Pas de contour
  controlP5 = new ControlP5(this); // Création d'une nouvelle interface Control P5
  
  //controlP5.addKnob("knob",0, 360, 0, 10,10,50); // création d'un bouton pitch
  //controlP5.addToggle("toggle", true, 160,10,50,50); // création d'un bouton ouvert ou eteint
  //controlP5.addSlider("slider",0, 255, 123, 240, 10,50,20); // création d'une barre slide de valeurs

   // Constructeur de Paramétrage du premier Bouton Knob
   myKnobA = controlP5.addKnob("knobValue")
              .setRange(0,255) // Détermination du segment de valeur compris entre 0 et 255
              .setValue(60) // Détermination de la valeur initiale à l'affichage
              .setPosition(510,50) // Position du bouton dans la fenêtre d'affichage
              .setRadius(40) // Diamètre du bouton
              .setDragDirection(Knob.VERTICAL) // Détermination du mouvement bouton à la verticale
              ;
   
   
   // Constructeur de Paramétrage du deuxième Bouton Knob            
   myKnobB = controlP5.addKnob("knobValue2")
               .setRange(0,255) // Détermination du segment de valeur compris entre 0 et 255
               .setValue(150) // Détermination de la valeur initiale à l'affichage
               .setPosition(510,200) // Position du bouton dans la fenêtre d'affichage
               .setRadius(40) // Diamètre du bouton
               .setDragDirection(Knob.VERTICAL) // Détermination du mouvement bouton à la verticale
               ;
   
   
   // Constructeur de Paramétrage du troisième Bouton Knob
   myKnobC = controlP5.addKnob("knobValue3")
               .setRange(0,255) // Détermination du segment de valeur compris entre 0 et 255
               .setValue(60) // Détermination de la valeur initiale à l'affichage
               .setPosition(510,350) // Position du bouton dans la fenêtre d'affichage
               .setRadius(40) // Diamètre du bouton
               .setDragDirection(Knob.VERTICAL) // Détermination du mouvement bouton à la verticale
               ;

  // Affichage caméra
  String[] cameras = Capture.list(); 
  
  if (cameras.length == 0) { // Initialisation d'une boucle if
    println("There are no cameras available for capture."); // Si pas de caméra disponible
    exit(); // alors fin du programme
  } else { // cas contraire
    println("Available cameras:"); // si caméra disponible
    for (int i = 0; i < cameras.length; i++) { // alors incémentation de la caméra
      println(cameras[i]);

    }
    
    cam = new Capture(this, width, height); // création d'une nouvelle image caméra
    cam.start(); // démarage de la caméra

  }      
}



 
// Initialisation des boucles d'affichages

void draw() { 
    
  background(myColorBackground); // couleur du fond
   
   if (cam.available() == true) { // initialisation de la boucle d'affichage caméra
    cam.read(); // lecture de la caméra
  }
  
 image(cam, 0, 0); 
 
 
   // Boucle d'oscillation du rendu visuel appliqué au Knob A
    for (int i = 0; i < 640; i = i+2) { // largeur
    for (int j = 0; j < 480; j = j+2) { // longueur
      fill(cam.get(i, j)*10,knobValue); // Remplir 10 fois les valeurs i et j
      rect(i, j, 2,2); // carrés
    }
  }


   // Boucle d'oscillation du rendu visuel appliqué au Knob B
  for (int i = 0; i < 640; i = i+2) { // largeur
   for (int j = 0; j < 480; j = j+2) { // longueur
     fill(cam.get(i, j),knobValue2); // Remplir les valeurs i et j
     tint(random(255), random(255), random(255), knobValue2); // filtre de couleur aléatoire
     
   }
 }
 
 
   // Boucle d'oscillation du rendu visuel appliqué au Knob C
  for (int i = 0; i < 640; i = i+2) { // largeur
   for (int j = 0; j < 480; j = j+2) { // longueur
     fill(cam.get(i, j)/20,knobValue3); // Remplir les valeurs i et j divisé par 40
     rect(i, j, 2,2); // carrés
   }
 }
  
}


// Méthode pour Prendre une photo en appuyant sur la touche ENTER
void keyPressed() {
  if (key == ENTER) {
   
    saveFrame("image-"+hour()+minute()+second()+".png");
  }
}



// FIN DU PROGRAMME //
