/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.glib;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gstreamer.lowlevel.GMainContext;
import org.gstreamer.lowlevel.GSource;
import org.gstreamer.lowlevel.GlibAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainContextExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final GMainContext context;
    private GSource idleSource = null;
    private final List<Runnable> bgTasks = new LinkedList<Runnable>();
    private volatile boolean running = true;
    private final Callable<Boolean> idleCallback = new Callable<Boolean>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            ArrayList tasks = new ArrayList();
            List list = MainContextExecutorService.this.bgTasks;
            synchronized (list) {
                tasks.addAll(MainContextExecutorService.this.bgTasks);
                MainContextExecutorService.this.bgTasks.clear();
            }
            for (Runnable r : tasks) {
                r.run();
            }
            return false;
        }
    };

    public MainContextExecutorService(GMainContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLater(Runnable r) {
        List<Runnable> list = this.bgTasks;
        synchronized (list) {
            boolean empty = this.bgTasks.isEmpty();
            this.bgTasks.add(r);
            if (empty) {
                this.idleSource = GlibAPI.GLIB_API.g_idle_source_new();
                this.idleSource.setCallback(this.idleCallback);
                this.idleSource.attach(this.context);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        List<Runnable> list = this.bgTasks;
        synchronized (list) {
            tasks.addAll(this.bgTasks);
            this.bgTasks.clear();
        }
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        List<Runnable> list = this.bgTasks;
        synchronized (list) {
            return !this.isShutdown() && this.bgTasks.isEmpty();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit units) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execute(Runnable runnable) {
        this.invokeLater(runnable);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit units) {
        return new ScheduledTimeout<Object>(Executors.callable(runnable), delay, units);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit units) {
        return new ScheduledTimeout<V>(callable, delay, units);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialiDelay, long period, TimeUnit units) {
        return new ScheduledTimeout<Object>(Executors.callable(runnable), initialiDelay, period, units);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialiDelay, long delay, TimeUnit units) {
        return new ScheduledTimeout<Object>(Executors.callable(runnable), initialiDelay, delay, units);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduledTimeout<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private volatile GSource source;
        private Callable<Boolean> delayCallback;
        private Callable<Boolean> periodCallback;
        private final long period;
        private final TimeUnit units;

        public ScheduledTimeout(Callable<V> call, long delay, TimeUnit units) {
            this(call, delay, 0L, units);
        }

        public ScheduledTimeout(Callable<V> call, long delay, long period, TimeUnit units) {
            super(call);
            this.delayCallback = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    if (ScheduledTimeout.this.period != 0L && !ScheduledTimeout.this.isCancelled()) {
                        ScheduledTimeout.this.start(ScheduledTimeout.this.period, ScheduledTimeout.this.periodCallback);
                    }
                    if (ScheduledTimeout.this.period != 0L) {
                        ScheduledTimeout.this.runAndReset();
                    } else {
                        ScheduledTimeout.this.run();
                    }
                    return false;
                }
            };
            this.periodCallback = new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    ScheduledTimeout.this.runAndReset();
                    return !ScheduledTimeout.this.isCancelled();
                }
            };
            this.period = period;
            this.units = units;
            this.start(delay, this.delayCallback);
        }

        private final int getMilliseconds(long time) {
            return (int)this.units.toMillis(time);
        }

        private void start(long timeout, Callable<Boolean> callback) {
            int milliseconds = this.getMilliseconds(timeout);
            if (milliseconds % 1000 == 0) {
                try {
                    this.source = GlibAPI.GLIB_API.g_timeout_source_new_seconds(milliseconds / 1000);
                }
                catch (UnsatisfiedLinkError e) {
                    this.source = GlibAPI.GLIB_API.g_timeout_source_new(milliseconds);
                }
            } else {
                this.source = GlibAPI.GLIB_API.g_timeout_source_new(milliseconds);
            }
            this.source.setCallback(callback);
            this.source.attach(MainContextExecutorService.this.context);
        }

        @Override
        public long getDelay(TimeUnit u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int compareTo(Delayed delayed) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

