/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GType
extends IntegerType {
    public static final int SIZE = Native.SIZE_T_SIZE;
    private static final GType[] cache = new GType[22];
    public static final GType INVALID;
    public static final GType NONE;
    public static final GType INTERFACE;
    public static final GType CHAR;
    public static final GType UCHAR;
    public static final GType BOOLEAN;
    public static final GType INT;
    public static final GType UINT;
    public static final GType LONG;
    public static final GType ULONG;
    public static final GType INT64;
    public static final GType UINT64;
    public static final GType ENUM;
    public static final GType FLAGS;
    public static final GType FLOAT;
    public static final GType DOUBLE;
    public static final GType STRING;
    public static final GType POINTER;
    public static final GType BOXED;
    public static final GType PARAM;
    public static final GType OBJECT;
    public static final GType VARIANT;
    private final String description;

    private static GType init(int v, String description) {
        return GType.valueOf(v << 2, description);
    }

    public GType(long t, String description) {
        super(SIZE, t);
        this.description = description;
    }

    public GType(long t) {
        this(t, "?");
    }

    public GType() {
        this(0L);
    }

    public static GType valueOf(long value) {
        return GType.valueOf(value, "?");
    }

    public static GType valueOf(long value, String description) {
        if (value >= 0L && value >> 2 < (long)cache.length) {
            return cache[(int)value >> 2];
        }
        return new GType(value, description);
    }

    public static GType valueOf(Class<?> javaType) {
        if (Integer.class == javaType || Integer.TYPE == javaType) {
            return INT;
        }
        if (Long.class == javaType || Long.TYPE == javaType) {
            return INT64;
        }
        if (Float.class == javaType || Float.TYPE == javaType) {
            return FLOAT;
        }
        if (Double.class == javaType || Double.TYPE == javaType) {
            return DOUBLE;
        }
        if (String.class == javaType) {
            return STRING;
        }
        throw new IllegalArgumentException("No GType for " + javaType);
    }

    public Object fromNative(Object nativeValue, FromNativeContext context) {
        return GType.valueOf(((Number)nativeValue).longValue(), "");
    }

    public String toString() {
        return "[" + this.description + ":" + this.longValue() + "]";
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            GType.cache[i] = new GType(i << 2);
        }
        INVALID = GType.init(0, "INVALID");
        NONE = GType.init(1, "NONE");
        INTERFACE = GType.init(2, "INTERFACE");
        CHAR = GType.init(3, "CHAR");
        UCHAR = GType.init(4, "UCHAR");
        BOOLEAN = GType.init(5, "BOOLEAN");
        INT = GType.init(6, "INT");
        UINT = GType.init(7, "UINT");
        LONG = GType.init(8, "LONG");
        ULONG = GType.init(9, "ULONG");
        INT64 = GType.init(10, "INT64");
        UINT64 = GType.init(11, "UINT64");
        ENUM = GType.init(12, "ENUM");
        FLAGS = GType.init(13, "FLAGS");
        FLOAT = GType.init(14, "FLOAT");
        DOUBLE = GType.init(15, "DOUBLE");
        STRING = GType.init(16, "STRING");
        POINTER = GType.init(17, "POINTER");
        BOXED = GType.init(18, "BOXED");
        PARAM = GType.init(19, "PARAM");
        OBJECT = GType.init(20, "OBJECT");
        VARIANT = GType.init(21, "VARIANT");
    }
}

