/*

  Thomas Leloup
  Programme webcam/boutons/applications de filtres
  À améliorer = l'ergonomie des boutons et les filtres
  
*/

//importation librairie vidéo
import processing.video.*;

//attribut balle pong
ArrayList collectionBalle;
int Nballes = 100; // nombre de balles pour l'effet balle 

//attribut des boutons
button ton1;
button ton2;
button ton3;
button ton4;
button ton5;
button ton6;
button ton7;
button ton8;

//attribut boolean pour bouton
boolean overBox = false;
boolean locked = false;
boolean singlePress = false;

//boîte de particules de pluie
Drop[] drops = new Drop[500];

//attribut pour trame de points  
ArrayList<Circle> circles;
int space;

//attribut pour la création de neige
PVector xx, yy, fcx, fcy, sx, sy;
int seed = 0, cell = 15;
Boolean randomized = true;

//attribut typographie
PFont font;

//déclaration de la caméra  
Capture cam;

///////////////////////////////////////////////////////////////////////////////////

void setup() {
  
  //taille zone de travail
  size(1280, 760);
    //on attribue la webcam à la caméra puis démarrage
    cam = new Capture(this, width, height-40);
    cam.start(); 
  //initialisation de l'effet neige
  initialize();
  //mode de couleur RVB
  colorMode(RGB);
  //initialisation des boutons  
  ton1 = new button();
  ton2 = new button();
  ton3 = new button();
  ton4 = new button();
  ton5 = new button();
  ton6 = new button();
  ton7 = new button();
  ton8 = new button();
  
  
//les balles ont une nouvelle boîte
collectionBalle = new ArrayList();
//pour i compris entre 0 et nombre de balles
for(int i = 0; i<Nballes; i++){
   
   // création du vecteur position
   PVector p = new PVector(floor(random(50,width-50)), // x
                           floor(random(50,height-50))); //y
                           
  // création du vecteur position
   PVector d = new PVector(floor(random(-8,8)), //dx
                       floor(random(-8,8))) ; //dy
   
   //une nouvelleballe de classe balle
   balle nouvelleBalle = new balle(
                       p,// vecteur position
                       color(random(0,255),random(0,255),random(0,255)),
                       floor(random(5,30)), //20,  // d
                       d// vecteur déplacement
                        );
    //ajouter la nouvelleballe à la collection                   
    collectionBalle.add(nouvelleBalle);
 }
  //pour i compris entre 0 et taille du drop(chute d'eau)
  for (int i = 0; i < drops.length; i++) {
    //chute des gouttes i prend les valeurs de la classe drop
    drops[i] = new Drop();
  }
  
  //pointes de trame
  circles = new ArrayList();
    //distance entre les points
    space = 60;
    
    //ajout de points dans la zone de travail en fonction de l'espace entre les balles et les balles
    for (int i = -2 * space ; i <= (width) + space; i += space) {
        for (int j = -2 * space ; j <= (height) + space; j += space) {
            circles.add(new Circle(i, j));
        }
    }
  
}

///////////////////////////////////////////////////////////////////////////////////

// initialisation des flocons de neige
void initialize() {
  seed += frameCount;
  randomSeed((int)random(1000) + frameCount);
  //coordonnées pour les flocons de neige
  xx = new PVector(random(10, 110), random(10, 110));
  yy = new PVector(random(10, 110), random(10, 110));
  sx = new PVector(random(30, 70), random(30, 70));
  sy = new PVector(random(30, 70), random(30, 70));
  fcx = new PVector(random(20, 70), random(20, 70));
  fcy = new PVector(random(20, 70), random(20, 70));
}

///////////////////////////////////////////////////////////////////////////////////

void draw() {
  
  //30 images par seconde
  frameRate(30);
  
    //fond noir
    background(0);
    
     //si caméra est disponible, la lire
     if (cam.available() == true) {
    cam.read();
  }
  
  //la zone de travail est rempli par la caméra
  image(cam, 0,0);
  
 //dessin des boutons (couleurs et positions)
  ton1.setFill(40,39,45);
  ton2.setFill(40,39,45);
  ton3.setFill(40,39,45);
  ton4.setFill(40,39,45);
  ton5.setFill(40,39,45);
  ton6.setFill(40,39,45);
  ton7.setFill(40,39,45);
  ton8.setFill(40,39,45);
  ton1.draw(0,height-40,width/8,40);
  ton2.draw(1*width/8,height-40,width/8,40);
  ton3.draw(2*width/8,height-40,width/8,40);
  ton4.draw(3*width/8,height-40,width/8,40);
  ton5.draw(4*width/8,height-40,width/8,40);
  ton6.draw(5*width/8,height-40,width/8,40);
  ton7.draw(6*width/8,height-40,width/8,40);
  ton8.draw(7*width/8,height-40,width/8,40);
  
  //définition typographie et placement sur la zone de travail
  pushStyle();
  font = createFont("Montserrat-SemiBold.ttf", 14);
  textFont(font);
  fill(255);
  text("Saturation", 0*width/8 +44, height-15);
  text("Déformation", 1*width/8 +38, height-15);
  text("Pong", 2*width/8 +63, height-15);
  text("Pluie", 3*width/8 +63, height-15);
  text("Trame", 4*width/8 +60, height-15);
  text("Neige", 5*width/8 +60, height-15);
  text("Noir & Blanc", 6*width/8 +38, height-15);
  text("Négatif", 7*width/8 +58, height-15);
  popStyle();
  
///////////////////////////////////////////////////////////////////////////////////  
  
  //BOUTON 1 SATURATION
  if(ton1.clicked()){ //au clic (voir class bouton)
     for (int i = 0; i < width; i = i+6) { //i en fonction de largeur
  for (int j = 0; j < height-40; j = j+6) { //j en fonction de hauteur -40
    pushStyle();    
    fill(cam.get(i, j)*4); //remplir avec les pixels de la caméra x 4 (ici le chiffre représente la déformation des couleurs)
    rect(i, j, 5,5); //petit carré ou "pixel de caméra"
    popStyle();  
}}
    fill(255,50); //bouton rectangulaire (saturation) rempli de gris
    rect(0,height-40,width/8,40);
  
} 

///////////////////////////////////////////////////////////////////////////////////

  //BOUTON 2  DÉFORMATION
  else if(ton2.clicked()){
      for (int i = 0; i < width; i = i+10) {
  for (int j = 0; j < height-40; j = j+10) {
    pushStyle();
    stroke(cam.get(i, j));
    fill(cam.get(i, j));  // rempli de la caméra
    ellipse(i, j, 10,10); // sur des ellipses
    popStyle();  
}}
    fill(255,50); //bouton déformation rempli
    rect(1*width/8,height-40,width/8,40);
  
} 

///////////////////////////////////////////////////////////////////////////////////  
  
  //BOUTON 3  PONG
  else if(ton3.clicked()){
    
 //pour i compris entre 0 et la taille de la collection   
 for(int i=0;i<collectionBalle.size();i++){ 
   pushStyle();
   noStroke();
   fill(cam.get(0,height)*4); //les balles prennent les couleurs de la caméra
   //selectionner la balle i du arraylist
    balle b = (balle) collectionBalle.get(i);
    
    // affiche la balle
    b.affiche();   
    // deplaclement de la balle
    b.deplacement();  
    // collision
    b.collision();
    popStyle();
  }

    fill(255,50); //remplissage bouton pong
    rect(2*width/8,height-40,width/8,40);
  }
  
///////////////////////////////////////////////////////////////////////////////////
  
    //BOUTON 4  PLUIE
    else if(ton4.clicked()){
      pushStyle();
      for (int i = 0; i < drops.length; i++) {
      drops[i].fall(); //afficher tombée
      drops[i].show(); //afficher goutte
      }
      popStyle();
      
    fill(255,50); //bouton pluie
    rect(3*width/8,height-40,width/8,40);
    
    }
    
///////////////////////////////////////////////////////////////////////////////////    
    
    //BOUTON 5  TRAME
    else if(ton5.clicked()){
    

    for (Circle c : circles) {
        c.update(); //afficher boucle
        c.draw();  //afficher dessin cercle
    }
     
      fill(255,50); //bouton trame
    rect(4*width/8,height-40,width/8,40);

    }
    
///////////////////////////////////////////////////////////////////////////////////    
    
    //BOUTON 6  NEIGE
    else if(ton6.clicked()){
    pushStyle();
      noStroke();
  fill(45, 23);
  rect(0, 0, width, height);

  randomSeed(seed);

  float fc = float(frameCount);
  strokeWeight(3);
  stroke(255);
  float x, y, maxx, minx, maxy, miny;
  for (float i = 0; i < width; i += cell)
  {
    for (float j = 0; j < height-40; j += cell)
    {
      //fonction aléatoire sur la largeur de travail pour x => i
      x = randomized ? random(width) : i; 
      //fonction aléatoire sur la hauteur de travail pour y => j
      y = randomized ? random(height-40) : j;
      
    //hauteur de vague (cycle ondulatoire) maximale sur x et y
      //max x = coordonnées de X x X x coefficient de rotation en fontion de X + largeur
      maxx =  xx.x * (1 + sin(y/sx.x + fc/fcx.x)) + width; 
      //min x = coordonnées de -X x Y x coefficient de rotation en fonction de y
      minx = -xx.y * (1 + sin(y/sx.y + fc/fcx.y)); 
      x = map(x, 0, width, minx, maxx); //remappage de x 0=> minx et de width => maxx
      if (x > 0 && x < width) { //pour x compris entre 0 et largeur
        maxy =  yy.x * (1 + sin(x/sy.x + fc/fcy.x)) + height;
        miny = -yy.y * (1 + sin(x/sy.y + fc/fcy.y));
        y = map(y, 0, height, miny, maxy); //remappage de y 0=> miny et de width => maxy
        if (y > 0 && y < height-40){ //pour x compris entre 0 et largeur
          point(x,y);
      }
    }
  }}
  
    popStyle();
    fill(255,50); //bouton neige
    rect(5*width/8,height-40,width/8,40);
    
    }
   
///////////////////////////////////////////////////////////////////////////////////    
    
    //BOUTON 7  NOIR & BLANC
    else if(ton7.clicked()){
    
    pushStyle();
    image(cam, 0,0); 
    filter(GRAY); //filtre noir et blanc
    popStyle();
    
     
    fill(255,50); //bouton N&B
    rect(6*width/8,height-40,width/8,40);
    }
    
///////////////////////////////////////////////////////////////////////////////////    
    
    //BOUTON 8  NÉGATIF
    else if(ton8.clicked()){
    
    pushStyle();
    image(cam, 0,0);  
    filter(INVERT); //filtre inversion 
    
    popStyle();
    
     
    fill(255,50); //bouton négatif
    rect(7*width/8,height-40,width/8,40);
    }
    
///////////////////////////////////////////////////////////////////////////////////    
   
   else {
       image(cam, 0,0); //si il n'y a plus d'effet on reprend la caméra

  }
}

///////////////////////////////////////////////////////////////////////////////////

void keyPressed() {
  if (key == ENTER) { //prendre une photo avec le bouton ENTRÉE
   
    saveFrame("image-"+hour()+minute()+second()+".png");
    //img.save("image-"+hour()+minute()+second()+".png");
  }
}