import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class weaving extends PApplet {

Grid grid;
float ran = 9;

public void setup() {
  
  noFill();
  grid = new Grid(70, 13);
}
public void draw() {
  grid.render();
}


class Grid {
  int d;
  int o; 
  PVector a, dir;
  ArrayList points = new ArrayList();
  int l =-1;


  Grid(int d_, int o_) {
    points.clear();
    d=d_;
    o=o_;

    for (int i=0; i<d*d; i++) {
      PVector s = new PVector(i/d*o, i%d*o);
      points.add(s);
    }
  }
  public int di() {
    return d;
  }
  public int od() {
    return o;
  }

  public void render() {
    background(0xffFFFFFF);
    stroke(0xff050000);
    //translate(width/2-(d*o/2), height/2-(d*o/2));
    for (int i=0; i<d*d; i++) {
      PVector pr = (PVector)points.get(i);
      a = new PVector(mouseX, mouseY);
      PVector dir = PVector.sub(a, pr);
      dir.normalize();
      dir.div(dist(mouseX, mouseY, pr.x, pr.y)/12);
      dir.limit(2.3f);
      pr.sub(dir);
    }
    for (int i=0; i<d*(d-1)-1; i++) {
      if ((i+1)%d>1) {
        PVector pt = (PVector)points.get(i);
        PVector pt2 = (PVector)points.get(i+d);
        PVector pt3 = (PVector)points.get(i+d+1);
        PVector pt4 = (PVector)points.get(i+1);
        line_new(pt.x, pt.y, pt2.x, pt2.y);
      }
    }
  }
}


public void line_new(float xx, float yy, float xx1, float yy1) {
  PVector  x = new PVector(xx, yy);
  PVector  x1 = new PVector(xx1, yy1);
  PVector  v = PVector.sub(x1, x);
  float d = x1.dist(x);
  pushMatrix();
  translate(xx, yy);
  PVector  v1 = new PVector(v.x, v.y);
  PVector  v2 = new PVector(v.x, v.y);
  PVector  v3 = new PVector(v.x, v.y); 
  v1.setMag(d);
  v2.setMag(d/4);
  v3.setMag(d-d/4);
  bezier(0, 0, random(v2.x-ran, v2.x+ran), random(v2.y-ran, v2.y+ran), random(v3.x-ran, v3.x+ran), random(v3.y-ran, v3.y+ran), v1.x, v1.y);
  strokeWeight(5);
  point(random(v1.x-2, v1.x+2), random(v1.y-2, v1.y+2));
  strokeWeight(1);
  popMatrix();
}
  public void settings() {  size(900, 900, P2D); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "weaving" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
