/**  Affiche tactile interactive - 
*  Quand on appuie sur une touche, cela lance une image, une vidéo, une annim, un son, etc...
*/
/// librairies
import processing.sound.*;
import processing.video.*; 


// variables globales
PImage im; // une image
SoundFile son; // un son
Movie vid; // une vidéo

// bouton son image active ?
boolean image_active = false;

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

// variables liées à l'animation
boolean anim_active = false;
   
   
void setup() {
  size(500, 500);
  noStroke();
  background(0);
  
  // initialisation des variables globales
  im = loadImage("images/chien.jpg");
  
  // chargement du son
  son = new SoundFile(this, "sons/beat.aiff");
  //println(son.duration());
  
  // chargement de la video
  vid = new Movie(this, "videos/affiche.mp4"); 
  vid.loop();
  
  // init des variables liées à l'annimation
 
}

void draw() { 
 
  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug
  
  if (son_actif){
    float tempsEcoute = millis() - tempsDebutSon ;

   // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug
    
    if ( tempsEcoute >= son.duration()*1000){ // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }
  
    // gestion de la vidéo ////////////////////////////////////////
     if (video_active){
       image(vid, 0, 0, width, height);
     }
     
     // gestion de l'image
     if (image_active){
       float x = 30 + random(-20,20); // random sur la position
       float y = 30 + random(-20,20);
       image(im,x,y,200,200);
     }
     
     if (anim_active){
            
     }
  
}

void keyPressed() {
  if (key == CODED) {
    if (keyCode == LEFT) { // image
      image_active = !image_active;
    } 
    if (keyCode == RIGHT) { // son
      if (son_actif==false){ // le son ne joue pas
        son.play();
        tempsDebutSon = millis();
        son_actif = true; // bouton son_actif on
      }
    }
    if (keyCode == UP) { // video
      vid.play();
      video_active = true;
    }
    
    if (keyCode == DOWN) { // video
     
      anim_active = true;
    }
  } 
}

void movieEvent(Movie movie) {
  vid.read();  
}