void serialEvent(Serial myPort) {
  // read a byte from the serial port:
  int inByte = myPort.read();
  // if this is the first byte received, and it's an A,
  // clear the serial buffer and note that you've
  // had first contact from the microcontroller. 
  // Otherwise, add the incoming byte to the array:
  if (firstContact == false) {
    if (inByte == 'A') { 
      myPort.clear();          // clear the serial port buffer
      firstContact = true;     // you've had first contact from the microcontroller
      myPort.write('A');       // ask for more
    } 
  } 
  else {
    // Add the latest byte from the serial port to array:
    serialInArray[serialCount] = inByte;
    serialCount++;

    // If we have nbBytes=2 bytes:
    if (serialCount > nbBytes-1 ) {
      // concaténer les deux octets reçus
      donneePortSerie = int(serialInArray[0] << 8) + int(serialInArray[1]) ;
      
      // print the values (for debugging purposes only):
      //println(serialInArray[0] + "\t" + serialInArray[1]+"\t" + donneePortSerie);
      println("distance=" + donneePortSerie + "cm");

      // Send a capital A to request new sensor readings:
      myPort.write('A');
      // Reset serialCount:
      serialCount = 0;
    }
  }
}
