/*////////////// programme permettant de détecter des chocs lors des pas
  l'accéléromètre est fixé sur la chaussette de l'utilisateur
  algorithme :
  lors d'un choc l'accéléromètre va subir des vibrations sous la forme d'oscillation.
  La norme de l'accélération va onc subir des variations pseudopérioqiques amorties sur un temps delta_T assez court (A MESURER.....)
  Les chocs sont donc détectés lorsqu'il y a une variation brutale de l'accélération.


  Remarque 1 : le temps delta_T du choc est proportionnel au nombre N de point d'échantillonnage. delta_T = N*Te, avec Te: période d'échantillonnage de la carte
  Remarque 2 : Il est nécessaire d'utiliser un tableau tabDelta_a[N] pour mémoriser les différentes valeurs de Delta_a

*/
#include <Wire.h>
#include <ADXL345.h>
ADXL345 adxl; //variable adxl is an instance of the ADXL345 library

// seuil sur l'accélération
float seuil_a = 1.5; /////////////// A MODIFIER ///////////////////////////////////////////////////

// compteur de pas
int compteurPas = 0;
int Delta_T = 100; // temps de pause correspondant à la durée approximative d'un choc

// debug
//float a_max = 0;


void setup() {
  Serial.begin(9600);
  //establishContact();
  initialiser_accelerometre();

}
void loop() {
  // mesure des accélérations suivant x, y, et z
  double xyz[3];
  float ax, ay, az;

  adxl.getAcceleration(xyz); // lire les valeurs de ax, ay, az saut l'accéléromètre

  ax = xyz[0];
  ay = xyz[1];
  az = xyz[2];

  // calcul de la norme du vecteur accélération (3D)
  float a = sqrt(pow(ax, 2) + pow(ay, 2) + pow(az, 2));

  // Détection d'un choc par seillage de l'accélération
  if (a > seuil_a) {
    compteurPas ++;
    // Serial.println(compteurPas); // affichage des données
    delay(Delta_T); // patienter le temps que le choc détecté se termine et qu'il soit possible de détecter le choc suivant
  }

  // envoie des données via le port Serie
  String s = String(a); // conversion de l'accélération en une chaine de caractère
  Serial.println(s); // envoie de la chaine de caractère qui sera retrascrite sous Processing
//  delay(10);
//  Serial.print("Bonjour");
  //Serial.println('A');

 // delay(500);


}

//void establishContact() {
// while (Serial.available() <= 0) {
//      Serial.write('A');   // send a capital A
//      delay(300);
//  }
//}
