PImage I1, I2, I3;
int W, H;
int nbEntrelacement = 10; // nombre de "bande" d'images entrelacées


void setup() {
  size(1200, 1800);
  I1=loadImage("im1.png");
  I2=loadImage("im2.png");
  W=I1.width;
  H=I1.height;
  // entrelacement images
  I3=entrelacer(I1, I2, nbEntrelacement);
}

void draw() {
  //image(I1, 0, 0, W/2, H/2);
  //image(I2, 0, I1.height/2, W/2, H/2);
  image(I3, 0, 0, W, H/2);
}

PImage entrelacer(PImage I1, PImage I2, int N) {// I1 et I2, les deux images; N : nombre de bandes d'entrelacement
  // largeur et hauteur de l'image créée
  int W = min(I1.width, I2.width);
  int H = min(I1.height, I2.height);
  // création de l'image finale
  PImage I3 = createImage(2*W, H, RGB);
  // chargement des tableaux de pixels
  I1.loadPixels();
  I2.loadPixels();
  I3.loadPixels();

  // taille des bandes
  int L = floor(W/N);
  // processus d'entremacement
  /* n : indice de la bande et L largeur de la bande
   pour n=3, indices de I3 pour la bande issue de I1 : de 6*L à 7*L-1, Idem pour I2 : de 7*L à 8*L-1
   pour n=4, indices de I3 pour la bande issue de I1 : de 8*L à 9*L-1, Idem pour I2 : de 9*L à 10*L-1
   ...
   pour n=k, indices de I3 pour la bande issue de I1 : de (2*k)*L à (2*k+1)*L-1, Idem pour I2 : de (2*k+1)*L à 2*(k+1)*L-1
   */
  for (int i=0; i<W; i++) { // indice de la ligne dans I1 et I2
    for (int j=0; j<H; j++) {// indice de la colonne dans I1, I2, et I3
      // indice de la colonne atteinte par l'indice i 
      int n=floor(i/L); // partie entière de i/L
      // indice du pixel dans la nième colonne
      int k=i%L; // reste de la division euclidienne de i par L

      I3.pixels[j*I3.width+((2*n*L)+k)]=I1.pixels[j*W+i]; // première bande issue de I1
      I3.pixels[j*I3.width+((2*n+1)*L+k)]=I2.pixels[j*W+i]; // deuxième bande issue de I2
    }
  }

  // mise à jour des pixels dans l'image finale
  I3.updatePixels();

  return I3;
}

/// méthode transformant l'image comme vecteur unidimentionnel (une ligne), en matrice
color[][] imageVector2Matrix(PImage I) {
  // création d'une matrice ayant la taille de l'image I
  int W=I.width;
  int H =I.height;
  color[][] Iprim = new color[W][H];
  for (int i=0; i<W; i++) {
    for (int j=0; i<H; i++) {
      Iprim[i][j]=I.pixels[j*W+i];
    }
  }
  return Iprim;
}

/// méthode transformant l'image comme vecteur unidimentionnel (une ligne), en matrice
PImage  imageMatrix2Vector(color[][] Iprim) {
  // création d'une matrice ayant la taille de l'image I
  int W = Iprim.length;
  int H = Iprim[0].length;
  PImage I = createImage(W, H, RGB);
  for (int i=0; i<W; i++) {
    for (int j=0; i<H; i++) {
      I.pixels[j*W+i]=Iprim[i][j];
    }
  }
  return I;
}

void keyPressed(){
  if(key==ENTER){
    save("data/image_entrelacee.jpg");
    println("image entrelacée sauvegardée");
  }

}
