/* Réception des données issues du port Bluetooth - Module HC06 
Envoie des données reçues via le port série vers le programme Processing*/

#include <SoftwareSerial.h>
SoftwareSerial hc06(2, 3);
// réception des données envoyées sur le port bluetooth
String cmd = "";
int distance = 0;



// Gestion de la led
byte led = 13;
int Tblink = 20; // période de clignotement
float isBlink = false; // drapeau pour lancer le clignotement... ou non


void setup() {
  // pin 13 OUTPUT
  pinMode(led, OUTPUT);

  //Initialiser le  Serial Monitor
  Serial.begin(9600);
  //Initialiser le  Bluetooth Serial Port
  hc06.begin(9600);
}
void loop() {
  //Lecture des données depuis le module HC06
  while (hc06.available() > 0) {
    cmd += (char)hc06.read();
  }
  //Select function with cmd
  if (cmd != "") {
    // convertir la comande en un entier
    distance = cmd.toInt(); // conversion de la chaine de caractère en un entier : distance mesurée

    cmd = ""; //reset cmd
  }
  // envoie des données sur le port Série -> Processing
  Serial.println(distance);  
  clignoterLed(led, Tblink, Tblink); // allumer la led à chaque envoie de donnée

  // patienter x ms
  delay(100);
}
