ArrayList<String> rechercheTousLesSons() {
  ArrayList<String> nomDesSons = new ArrayList<String>();

  // Using just the path of this sketch to demonstrate,
  // but you can list any directory you like.
  String path = sketchPath();

  // recherche de tous les dossiers et fichiers dans le dossier du sketch parent
  ArrayList<File> allFiles = listFilesRecursive(path);

  // recherche de tous les fichiers ".wav" et ".aiff"
  if (allFiles != null) {  

    // recherche de tous les fichiers son : .mp3, .aif, .wav
    for (File f : allFiles) {
      String fname = f.getName(); 
      String fileExt = fname.toLowerCase().substring(fname.lastIndexOf('.') + 1) ; // récupérer l'extension du fichier
      if (extensions.contains(fileExt)) {
        // fname.toLowerCase().endsWith(".wav") || fname.toLowerCase().endsWith(".aiff") || fname.toLowerCase().endsWith(".mp3")
        nomDesSons.add(f.getAbsolutePath());
      }
    }
  }

  //println("\nnom de tous les fichiers son: ");
  //printArray(nomDesSons.toArray());
  //println("-----------------------");

  return nomDesSons;
}

// Function to get a list of all files in a directory and all subdirectories
ArrayList<File> listFilesRecursive(String dir) {
  ArrayList<File> fileList = new ArrayList<File>(); 
  recurseDir(fileList, dir);
  return fileList;
}

// Recursive function to traverse subdirectories
void recurseDir(ArrayList<File> a, String dir) {
  File file = new File(dir);
  if (file.isDirectory()) {
    // If you want to include directories in the list
    a.add(file);  
    File[] subfiles = file.listFiles();
    for (int i = 0; i < subfiles.length; i++) {
      // Call this function on all files in this directory
      recurseDir(a, subfiles[i].getAbsolutePath());
    }
  } else {
    a.add(file);
  }
}
