/**  Affiche tactile interactive - 
 *  Quand on appuie sur une touche (UP, DOWN, RIGHT, LEFT et espace ' '), cela lance une image, une vidéo, une annim, un son, etc...
 */
/// librairies
import processing.sound.*;
import processing.video.*; 
import processing.serial.*;


// variables globales
SoundFile son; // un son - un seul lecteur CD audio
ArrayList <String> nomDesSons ;
java.util.List<String> extensions;

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué


/// dialogue avec la carte Arduino
Serial myPort;  // Create object from Serial class
boolean firstContact = false;        // Whether we've heard from the microcontroller
int donneePortSerie; // entier converti de la chaine de caractère reçue sur le port série

// compteur sonnerie
int interationSonnerie = 2;
int compteurSonnerie = 0;
int indiceSon = 0;

// debug
boolean debug = false;


void setup() { // initialisation des paramètres d'affichage & chargement des sons, vidéos, etc.
  size(500, 500);
  noStroke();
  background(0);

  // chargement des nom des sons
  String[] extensionsArray = {"wav", "aiff", "mp3"};
  extensions = java.util.Arrays.asList(extensionsArray);

  nomDesSons = rechercheTousLesSons();

  son = new SoundFile(this, nomDesSons.get(0));

  /// Port série
  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}

void draw() {
  fill(0);
  rect(0, 0, width, height);
  fill(255);
  text(donneePortSerie, 100, 100);
}

void serialEvent(Serial myPort) {
  // lire la donnée sur la port série
  int inByte = myPort.read();

  if (firstContact == false) {
    if (inByte == 'A') { 
      myPort.clear();          // clear the serial port buffer
      firstContact = true;     // you've had first contact from the microcontroller
      myPort.write('A');       // ask for more
      println("communication avec la carte Arduino établie");
    }
  } else {
    donneePortSerie = inByte; // lire la donnée et la stoquer dans inBuffer (chaine de caractères - String)
    //debug
    if (debug) {
      println("bouton=" + donneePortSerie);
    }

    // tester la valeur du bouton et gérer le son
    gestionSon();

    // envoyer 'A' à la carte Arduino pour nouvelle lecture du bouton
    myPort.write('A');
  }
}
