class balle {
  //attributs de la balle
  float x; //position x de la balle
  float y; //position y de la balle
  float dy; //déplacement y
  float d; //diamètre de la balle
  color c; //couleur de la balle
  char l;
  // attribut liés au saut
  float y0; //position y de la balle
  float V0; // vitesse initiale de la balle lors du saut
  int t; // temps lié au mouvement (en frames : ici t=n, avec n, le nombre d'itération de la boucle draw() à partir du début du saut (à t=0)
  boolean isJumping; //variable booléenne permettant de savoir si la balle est en action de saut ou non
  float g; // gravité
  float ymin; // ordonnée minimun atteinte lors du saut
  float h; // hauteur du saut
  int nbSaut;  // nb de sauts effectuée par la balle
  
  // constructeur 1
  balle(float _x, float _y, float _dy, float _d, color _c){
    // initialisation des attributs de la balle
    x = _x;
    y = _y;
    dy = _dy;
    d = _d;
    c = _c;
    l  = 'o';
    // initialisation des attributs lié au saut
    y0=y;
    V0 = -5; // 2 pix par frames
    t=0;
    isJumping=false;
    g = 0.05;
    
  }
  
  // constructeur 2
  // possibilité de régler la vitesse initiale et la gravité
  balle(float _x, float _y, float _dy, float _d, color _c, float _V0, float ymin){ 
    // initialisation des attributs de la balle
    x = _x;
    y = _y;
    dy = _dy;
    d = _d;
    c = _c;
    l  = 'o';
    // initialisation des attributs lié au saut
    y0=y;
    V0 = _V0;
    t=0;
    h = y0-ymin;
    //isJumping=false;
    isJumping=true;  ///// pour que le saut démare dès le lancement du programme
    g=pow(V0,2)/(2*h);
    nbSaut = 0;
  }
  // méthodes
  void afficher() {
    fill(c) ;
    ellipse(x, y, d, d) ;
  }
  void afficher(char lettre) {
    fill(c) ;
    text(lettre,x,y) ;
  }
  
  void avancer() {
    y = y + dy ;
  }
  boolean rebondir() {
    boolean isRebond = false;
    // rebond suivant y
    if ((y+d/2 >= height) || (y-d/2 <= 0) ) {// bord vertical
      //background( random(255));
      dy = dy *(-1);// changer le sens de déplacement
      isRebond = true;
    }
    return isRebond;
  }
  
  void sauter(){
    // le modèle du saut est celui d'un objet soumis uniquement à la gravité g, 
    // c'est à dire le modèle de la chute libre
    // On considère uniquement un mouvement suivant y
    //    ___________► x
    //   |
    //   |     o  (v→)= = v(t).(uy→) avec v(t) algébrique
    //   |     ↓  (P→) : poids
    //   ▼
    //   y
    /* Dans ce système d'axe, la deuxième loi de newton donne appliqué au système {balle} donne :
      Σ(F→) = m*(a→) =(P→) = m*(g→) <=> (a→)= (g→)
      en projection sur l'axe (oy), on obtient : 
      a = d²y/dt² = g (car ici le poids (P→) est colinéaire et de même sens que (uy→),
      avec g : gravité (sur Terre gT=9,81 m*s-², sur la Lune gL = 1,6 m*s-², etc...)
      soit : 
        -  v(t) = g*t + V0 
        -  y(t) = y0 + V0*t + (1/2)*g*t², 
      avec y0 : le position de la balle à t=0 (début du saut) 
      et V0 : vitesse initiale algébrique de la balle à t=0 (début du saut)
      
      y(t) est minimal lorsque dy(t)/dt = v(t) = 0 <=> tmin = -V0/g
      D'où, ymin = y(tmin) = y0 - V0²/g + V0²/(2*g) = y0 - V0²/(2*g)
      pour que la balle ne dépasse pas du cadre, il faut que ymin>0 <=> y0 > V0²/(2*g)
      la condition sur la vitesse initiale est donc que : V0 < √(y0/(2*g))
      
      Ici, l'unité de temps est la durée entre deux frames consécutive. 
      Ce temps est donc proportionnel au nombre "n" de frames qui s'est écoulé 
      à partir de la frame considérée comme le début du saut.
      Pour symplifier le modèle on considère ici que t=n, 
      avec n, le nombre d'itération de la boucle draw() à partir du début du saut (à t=0)
   
    */
    if (isJumping==true && y<=y0){
      // calcul de la nouvelle position de la balle
      // y  = y0 + V0*t + 0.5*g*t*t;
      y  = y0 + V0*t + 0.5*g*pow(t,2);;
      t++;
    }
    else{ // isJumping==false || y<=y0
      y=y0;
      t=0;
      nbSaut++;
      //isJumping=false;
    }
  }
}
